package com.rocoinfo.rocomall.service.wx;

import java.util.List;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.wx.Menu;

public interface IWxMenuService extends IBaseService<Menu> {
	/**
	 * 返回系统所有的一级菜单，如果有子菜单并且加载其子菜单
	 * 
	 * @return
	 */
	public List<Menu> findTopWithSubMenus();

	public void batchUpdateSeqs(List<Long> menuIdList, List<Integer> seqList);

	/**
	 * 获得菜单绑定的消息Id
	 * 
	 * @param menuId
	 * @return
	 */
	public String getMenuBoundedMessageId(final int menuId);

	/**
	 * @param messageId 消息Id
	 * @param menuId 菜单Id
	 */
	public void bindMenuMessageId(final String messageId, final int menuId);
}
