package com.rocoinfo.rocomall.utils;

import java.io.File;
import java.util.Date;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import org.springframework.util.StringUtils;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.PropertyHolder;

public final class EmailSender {
    
	private static final int PORT = 25;
	private static Session session = null;
	static {
    	Properties props= new Properties();
    	props.setProperty("mail.smtp.auth", "true");
    	props.setProperty("mail.transport.protocol", "smtp");
    	session= Session.getInstance(props);
    }
	
	
    
    /**
     * 发送邮件
     * @param receiver 收件人
     * @param subject 标题
     * @param mailContent 邮件内容
     * @param mimetype 内容类型 默认为text/plain,如果要发送HTML内容,应设置为text/html    参考使用：JsonUtils.TEXT_TYPE
     */
    public static void send(String receiver, String subject, String mailContent, String mimetype) {
    	send(new String[]{receiver}, subject, mailContent, mimetype);
    }
    
    /**
     * 发送邮件
     * @param receivers 收件人
     * @param subject 标题
     * @param mailContent 邮件内容
     * @param mimetype 内容类型 默认为text/plain,如果要发送HTML内容,应设置为text/html  
     */
    public static void send(String[] receivers, String subject, String mailContent, String mimetype) {
    	send(receivers, subject, mailContent, null, mimetype);
    }
    
    /**
     * 发送邮件
     * @param receivers 收件人
     * @param subject 标题
     * @param mailContent 邮件内容
     * @param attachements 附件
     * @param mimetype 内容类型 默认为text/plain,如果要发送HTML内容,应设置为text/html
     */
    public static void send(String[] receivers, String subject, String mailContent, File[] attachements, String mimetype){
        try {
        	MimeMessage mimeMessage = new MimeMessage(session);
        	String senderEmail = PropertyHolder.getEmailSender();
        	
        	String from = MimeUtility.encodeText("财迷派积分商城")  + "<%s>";
        	
        	//新华积分平台系统<xs.office@sina.com>
        	from = String.format(from, senderEmail);
        	
        	mimeMessage.setFrom(new InternetAddress(from)); //显示时：发件人邮件
            
            InternetAddress[] toAddress = new InternetAddress[receivers.length];
            for (int i=0; i<receivers.length; i++) {
                toAddress[i] = new InternetAddress(receivers[i]);
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, toAddress);//收件人邮件
            mimeMessage.setSubject(subject);
            mimeMessage.setReplyTo(new Address[]{new InternetAddress(senderEmail)});
            Multipart multipart = new MimeMultipart();
            //正文
            MimeBodyPart body = new MimeBodyPart();
            body.setContent(mailContent, (!StringUtils.isEmpty(mimetype) ? mimetype : JsonUtils.TEXT_TYPE) +";charset=" + Constants.DEFAULT_ENCODING);
            multipart.addBodyPart(body);//发件内容
            //附件
            if(attachements!=null){
	            for (File attachement : attachements) {
	                MimeBodyPart attache = new MimeBodyPart();
	               //ByteArrayDataSource bads = new ByteArrayDataSource(byte[],"application/x-any");
	                attache.setDataHandler(new DataHandler(new FileDataSource(attachement)));
	                String fileName = StringUtils.getFilename(attachement.getName());
	                attache.setFileName(MimeUtility.encodeText(fileName, Constants.DEFAULT_ENCODING, null));
	                multipart.addBodyPart(attache);
	            }
            }
            mimeMessage.setContent(multipart);
            mimeMessage.setSentDate(new Date());
        	Transport transport =session.getTransport();
			transport.connect(PropertyHolder.getEmailServer(),PORT,PropertyHolder.getEmailSender(),PropertyHolder.getEmailSenderPwd());
			transport.sendMessage(mimeMessage, mimeMessage.getAllRecipients());
            transport.close();
        } catch (Exception e) {
        	e.printStackTrace();
        	throw new RuntimeException("发送邮件失败！");
        }
    }
}