package com.rocoinfo.rocomall.utils;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

public class KuaiDi100Utils {

	private static String key = "2d4fd766749f57f6";
	
	public static void main(String[] args) {
		String json = KuaiDi100Utils.search("huitongkuaidi", "70056403270921");
		List<Map<String,String>> list = (List<Map<String,String>>)JsonUtils.fromJson(json, Map.class).get("data");
		System.out.println(list.size());
		for(Map<String,String> m : list){
			System.out.println(m);
		}
		//System.err.println(JsonUtils.fromJson(json, Map.class));
	}
	
	/**
	 * 
	 * @param com			要查询的快递公司代码
	 * @param orderNo	 	要查询的快递单号，请勿带特殊符号，不支持中文（大小写不敏感）
	 * @return
	 * 2015年10月27日 上午11:40:07
	 */
	public static String search(String com,String orderNo){
		return search(com,orderNo,null,null,null);
	}
	
	/**
	 * 
	 * @param com			要查询的快递公司代码
	 * @param orderNo	 	要查询的快递单号，请勿带特殊符号，不支持中文（大小写不敏感）
	 * @param show			返回类型：
							0：返回json字符串，
							1：返回xml对象，
							2：返回html对象，
							3：返回text文本。
							如果不填，默认返回json字符串。 
	 * @param muti			返回信息数量：
							1:返回多行完整的信息，
							0:只返回一行信息。
							不填默认返回多行。
	 * @param order			排序：
							desc：按时间由新到旧排列，
							asc：按时间由旧到新排列。
							不填默认返回倒序（大小写不敏感） 
	 * @return
	 * 2015年10月27日 上午11:26:22
	 */
	public static String search(String com,String orderNo,String show,
			String muti,String order){
		String content = "";
		try {
			StringBuilder path = new StringBuilder("http://api.kuaidi100.com/api?id="+key);
			if(StringUtils.isNotBlank(com)){
				path.append("&com="+com);
			}
			if(StringUtils.isNotBlank(orderNo)){
				path.append("&nu="+orderNo);
			}
			if(StringUtils.isNotBlank(show)){
				path.append("&show="+show);
			}
			if(StringUtils.isNotBlank(muti)){
				path.append("&muti="+muti);
			}
			if(StringUtils.isNotBlank(order)){
				path.append("&order="+order);
			}
			
			URL url = new URL(path.toString());
			URLConnection con = url.openConnection();
			con.setAllowUserInteraction(false);
			InputStream urlStream = url.openStream();
			String type = con.guessContentTypeFromStream(urlStream);
			String charSet = null;
			if (type == null)
				type = con.getContentType();

			if (type == null || type.trim().length() == 0 || type.trim().indexOf("text/html") < 0)
				return "";

			if (type.indexOf("charset=") > 0)
				charSet = type.substring(type.indexOf("charset=") + 8);

			byte b[] = new byte[10000];
			int numRead = urlStream.read(b);
			content = new String(b, 0, numRead);
			while (numRead != -1) {
				numRead = urlStream.read(b);
				if (numRead != -1) {
					String newContent = new String(b, 0, numRead, charSet);
					content += newContent;
				}
			}
			urlStream.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return content;
	}
	
}
