package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.dto.LogisticTrack.LogisticTrackItem;
import com.rocoinfo.rocomall.dto.admin.LogisticInfo;
import com.rocoinfo.rocomall.entity.wx.WXItem;
import com.rocoinfo.rocomall.entity.wx.WXMsg;
import com.thoughtworks.xstream.XStream;

/**
 * XStream工具类
 */
public final class XStreamUtils {

	private static XStream xStream = new XStream(new MyXppDriver());

	static {
		/**
		 * 有新的注解类请添加在这里
		 */
		xStream.processAnnotations(WXMsg.class);
		xStream.processAnnotations(WXItem.class);

		xStream.processAnnotations(LogisticInfo.class);
		xStream.processAnnotations(LogisticTrackItem.class);

		xStream.registerConverter(new CDATAConverter());
	}

	public static XStream getDefaultXStream() {
		return xStream;
	}
}
