/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall;

import com.rocoinfo.rocomall.utils.JsonUtils;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Lazy(value=false)
public class PropertyHolder
implements ServletContextAware {
    private static ServletContext servletContext;
    private static String imageBaseUrl;
    private static String uploadDir;
    private static String baseurl;
    private static String jsGenerateDir;
    private static String logisticUrl;
    private static String smsGateWay;
    private static String smsAppId;
    private static String smsAppSecret;
    private static String smsContentPrefix;
    private static String apiKey;
    private static String emailSender;
    private static String emailSenderPwd;
    private static String emailServer;
    private static String insuranceMale;
    private static String insuranceFemale;
    private static boolean isTest;
    private static Map<String, List<String>> columns;
    private static String ZXB_WAP_URL;
    private static String ZXB_PC_URL;
    private static String GENERATE_QRCODE_URL;

    public void setServletContext(ServletContext ctx) {
        servletContext = ctx;
        ctx.setAttribute("ctx", (Object)ctx.getContextPath());
        ctx.setAttribute("imageBaseUrl", (Object)imageBaseUrl);
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static String getSmsGateWay() {
        return smsGateWay;
    }

    public static String getSmsAppId() {
        return smsAppId;
    }

    public static String getSmsAppSecret() {
        return smsAppSecret;
    }

    public static String getSmsContentPrefix() {
        return smsContentPrefix;
    }

    public static String getLogisticUrl() {
        return logisticUrl;
    }

    public static String getImageBaseUrl() {
        return imageBaseUrl;
    }

    public static String getUploadDir() {
        return uploadDir;
    }

    public static String getJsGenerateDir() {
        return jsGenerateDir;
    }

    public static String getBaseurl() {
        return baseurl;
    }

    public static String getApiKey() {
        return apiKey;
    }

    public static String getEmailSender() {
        return emailSender;
    }

    public static String getEmailSenderPwd() {
        return emailSenderPwd;
    }

    public static String getEmailServer() {
        return emailServer;
    }

    @Value(value="${sms.gateway}")
    public void setSmsGateWay(String smsGateway) {
        smsGateWay = smsGateway;
    }

    @Value(value="${sms.appId}")
    public void setSmsAppId(String smsAppId) {
        PropertyHolder.smsAppId = smsAppId;
    }

    @Value(value="${sms.appSecret}")
    public void setSmsAppSecret(String smsAppSecret) {
        PropertyHolder.smsAppSecret = smsAppSecret;
    }

    @Value(value="${sms.contentPrefix}")
    public void setSmsContentPrefix(String smsContentPrefix) {
        PropertyHolder.smsContentPrefix = smsContentPrefix;
    }

    @Value(value="${image.base.url}")
    public void setImageBaseUrl(String imageBaseUrl) {
        PropertyHolder.imageBaseUrl = imageBaseUrl;
    }

    @Value(value="${upload.dir}")
    public void setUploadDir(String uploadDir) {
        PropertyHolder.uploadDir = uploadDir;
    }

    @Value(value="${js.generate.dir}")
    public void setJsGenerateDir(String jsDir) {
        jsGenerateDir = jsDir;
    }

    @Value(value="${baseurl}")
    public void setBaseurl(String baseurl) {
        PropertyHolder.baseurl = baseurl;
    }

    @Value(value="${order.logisticsInfo.addr}")
    public void setLogisticUrl(String logisticUrl) {
        PropertyHolder.logisticUrl = logisticUrl;
    }

    @Value(value="${email.sender}")
    public void setEmailSender(String emailSender) {
        PropertyHolder.emailSender = emailSender;
    }

    @Value(value="${email.sender.password}")
    public void setEmailSenderPwd(String emailSenderPassword) {
        emailSenderPwd = emailSenderPassword;
    }

    @Value(value="${email.server}")
    public void setEmailServer(String emailServer) {
        PropertyHolder.emailServer = emailServer;
    }

    @Value(value="${apikey}")
    public void setApiKey(String apiKey) {
        PropertyHolder.apiKey = apiKey;
    }

    public static String getFullImageUrl(String imagePath) {
        if (imagePath == null) {
            return null;
        }
        return PropertyHolder.getImageBaseUrl() + imagePath;
    }

    private static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    @Value(value="${tpy.insurance.male}")
    public void setInsuranceMale(String insuranceMale) {
        PropertyHolder.insuranceMale = insuranceMale;
    }

    @Value(value="${tpy.insurance.female}")
    public void setInsuranceFemale(String insuranceFemale) {
        PropertyHolder.insuranceFemale = insuranceFemale;
    }

    public static String getInsuranceMale() {
        return insuranceMale;
    }

    public static String getInsuranceFemale() {
        return insuranceFemale;
    }

    @Value(value="${tpy.insurance.isTest}")
    public void setIsTest(String isTest) {
        if (StringUtils.isEmpty((CharSequence)isTest)) {
            isTest = "false";
        }
        PropertyHolder.isTest = Boolean.parseBoolean(isTest);
    }

    public static boolean getIsTest() {
        return isTest;
    }

    @Value(value="${tpy.insurance.columns}")
    public void setColumns(String columns) {
        if (StringUtils.isEmpty((CharSequence)columns)) {
            columns = "{}";
        }
        PropertyHolder.columns = JsonUtils.fromJson(columns, Map.class);
    }

    public static Map<String, List<String>> getColumns() {
        return columns;
    }

    public static String getGenerateQrcodeUrl() {
        return GENERATE_QRCODE_URL;
    }

    @Value(value="${zxb.wap.url}")
    public void setGenerateQrcodeUrl(String generateQrcodeUrl) {
        GENERATE_QRCODE_URL = generateQrcodeUrl;
    }

    public static String getZxbWapUrl() {
        return ZXB_WAP_URL;
    }

    @Value(value="${zxb.wap.url}")
    public void setZxbWapUrl(String zxbWapUrl) {
        ZXB_WAP_URL = zxbWapUrl;
    }

    public static String getZxbPcUrl() {
        return ZXB_PC_URL;
    }

    @Value(value="${zxb.pc.url}")
    public void setZxbPcUrl(String zxbPcUrl) {
        ZXB_PC_URL = zxbPcUrl;
    }

    static {
        isTest = false;
        PropertyHolder.disableSslVerification();
    }
}

