/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.dto;

import com.rocoinfo.rocomall.entity.Catalog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogTreeDto {
    private Long id;
    private Map<String, Integer> a_attr = new HashMap<String, Integer>();
    private List<CatalogTreeDto> children;
    private String text;

    public List<CatalogTreeDto> getChildren() {
        return this.children;
    }

    public void setChildren(List<CatalogTreeDto> children) {
        this.children = children;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Map<String, Integer> getA_attr() {
        return this.a_attr;
    }

    public void setLevel(int level) {
        this.a_attr.put("data-lev", level);
    }

    public static CatalogTreeDto constructTree(CatalogTreeDto curCode, List<Catalog> orgList, int level) {
        if (CollectionUtils.isEmpty(orgList) || curCode == null) {
            return null;
        }
        ArrayList<CatalogTreeDto> childNodeList = new ArrayList<CatalogTreeDto>();
        Catalog org = null;
        for (int index = 0; index < orgList.size(); ++index) {
            org = orgList.get(index);
            if (org == null || !curCode.getId().equals(org.getParentId())) continue;
            CatalogTreeDto childNode = new CatalogTreeDto();
            childNode.setId(org.getId());
            childNode.setText(org.getName());
            childNode.setLevel(level);
            childNodeList.add(childNode);
        }
        if (CollectionUtils.isNotEmpty(childNodeList)) {
            curCode.setChildren(childNodeList);
        }
        ++level;
        for (CatalogTreeDto dto : childNodeList) {
            CatalogTreeDto.constructTree(dto, orgList, level);
        }
        return curCode;
    }
}

