/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.dto;

import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.ProductSpecial;
import com.rocoinfo.rocomall.entity.Sku;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;

public class SkuDto {
    private Long skuId;
    private String skuCode;
    private String skuName;
    private String attribute1;
    private String attribute2;
    private String attribute3;
    private Double cashAmt;
    private Integer cent;
    private Double mergeCashAmt;
    private Double mergeCent;
    private Long prodId;
    private Date listTime;
    private Long brandId;
    private String catalogIds;
    private String imgLoadUrl;

    public static SkuDto valueOf(Sku sku) {
        SkuDto dto = null;
        if (sku != null) {
            dto = new SkuDto();
            SkuDto.copyValue2Dto(dto, sku);
        }
        return dto;
    }

    public static SkuDto valueOf(ProductSpecial settingProd) {
        SkuDto dto = new SkuDto();
        Sku sku = settingProd.getSku();
        if (sku != null) {
            SkuDto.copyValue2Dto(dto, sku);
        }
        return dto;
    }

    private static void copyValue2Dto(SkuDto targetDto, Sku sourceSku) {
        targetDto.setSkuId(sourceSku.getId());
        targetDto.setSkuCode(sourceSku.getCode());
        targetDto.setSkuName(sourceSku.getName());
        targetDto.setAttribute1(sourceSku.getAttribute1());
        targetDto.setAttribute2(sourceSku.getAttribute2());
        targetDto.setAttribute3(sourceSku.getAttribute3());
        targetDto.setCashAmt(sourceSku.getCashAmt());
        targetDto.setCent(sourceSku.getCent());
        targetDto.setMergeCent(sourceSku.getMergeCent());
        targetDto.setMergeCashAmt(sourceSku.getMergeCashAmt());
        targetDto.setImgLoadUrl(sourceSku.getPreviewImagePath());
        Product prod = sourceSku.getProduct();
        targetDto.setProdId(prod.getId());
        targetDto.setListTime(prod.getListTime());
        if (prod.getBrand() != null) {
            targetDto.setBrandId(prod.getBrand().getId());
        }
        if (CollectionUtils.isNotEmpty(prod.getCatalogs())) {
            String comma = ",";
            StringBuilder cateIdBuf = new StringBuilder();
            cateIdBuf.append(",");
            for (Catalog cate : prod.getCatalogs()) {
                cateIdBuf.append(cate.getId()).append(",");
            }
            targetDto.setCatalogIds(cateIdBuf.toString());
        }
    }

    public Long getSkuId() {
        return this.skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return this.skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getAttribute1() {
        return this.attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1;
    }

    public String getAttribute2() {
        return this.attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2;
    }

    public String getAttribute3() {
        return this.attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3;
    }

    public Date getListTime() {
        return this.listTime;
    }

    public void setListTime(Date listTime) {
        this.listTime = listTime;
    }

    public Double getCashAmt() {
        return this.cashAmt;
    }

    public void setCashAmt(Double cashAmt) {
        this.cashAmt = cashAmt;
    }

    public Integer getCent() {
        return this.cent;
    }

    public void setCent(Integer cent) {
        this.cent = cent;
    }

    public Double getMergeCashAmt() {
        return this.mergeCashAmt;
    }

    public void setMergeCashAmt(Double mergeCashAmt) {
        this.mergeCashAmt = mergeCashAmt;
    }

    public Double getMergeCent() {
        return this.mergeCent;
    }

    public void setMergeCent(Double mergeCent) {
        this.mergeCent = mergeCent;
    }

    public Long getProdId() {
        return this.prodId;
    }

    public void setProdId(Long prodId) {
        this.prodId = prodId;
    }

    public Long getBrandId() {
        return this.brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getCatalogIds() {
        return this.catalogIds;
    }

    public void setCatalogIds(String catalogIds) {
        this.catalogIds = catalogIds;
    }

    public String getImgLoadUrl() {
        return this.imgLoadUrl;
    }

    public void setImgLoadUrl(String imgLoadUrl) {
        this.imgLoadUrl = imgLoadUrl;
    }
}

