/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.ProductImage;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Transient;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class Sku
extends IdEntity {
    private static final long serialVersionUID = 4770148383261348441L;
    private static final String BLANK = " ";
    private String code;
    private String name;
    private Product product;
    private String attribute1;
    private String attribute2;
    private String attribute3;
    private DictWarehouse wareHouse;
    private Integer stock;
    private Integer occupiedStock;
    private Integer virtualStock;
    private Integer warningStock;
    private Status status;
    private Boolean displayInlist;
    private String supplierProdCode;
    private Double cashAmt;
    private Integer cent;
    private Double mergeCashAmt;
    private Double mergeCent;
    private Double origCashAmt;
    private Integer origCent;
    private Double origMergeCashAmt;
    private Double origMergeCent;
    @Transient
    private List<ProductImage> productImages;
    @Transient
    private List<String> canDos;
    private String supplierName;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOccupiedStock() {
        return this.occupiedStock;
    }

    public void setOccupiedStock(Integer occupiedStock) {
        this.occupiedStock = occupiedStock;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public String getAttribute1() {
        return this.attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1;
    }

    public String getAttribute2() {
        return this.attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2;
    }

    public String getAttribute3() {
        return this.attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3;
    }

    public Integer getStock() {
        return this.stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public Integer getWarningStock() {
        return this.warningStock;
    }

    public void setWarningStock(Integer warningStock) {
        this.warningStock = warningStock;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Integer getVirtualStock() {
        return this.virtualStock;
    }

    public void setVirtualStock(Integer virtualStock) {
        this.virtualStock = virtualStock;
    }

    public List<ProductImage> getProductImages() {
        return this.productImages;
    }

    public void setProductImages(List<ProductImage> productImages) {
        this.productImages = productImages;
    }

    public void addImage(ProductImage skuImg) {
        if (skuImg != null) {
            if (this.productImages == null) {
                this.productImages = Lists.newArrayList();
            }
            this.productImages.add(skuImg);
        }
    }

    public int getAvailableStockQuantity() {
        if (this.stock != null && this.virtualStock != null && this.occupiedStock != null) {
            return Math.max(this.virtualStock + this.stock - this.occupiedStock, 0);
        }
        return 0;
    }

    public int calcLessStockAfterAddCart(int quantity) {
        return this.getAvailableStockQuantity() - quantity;
    }

    public boolean isOnSale() {
        boolean isSaleing = false;
        if (this.product != null) {
            isSaleing = Status.ENABLED.equals((Object)this.status) && Product.Status.LIST.equals((Object)this.product.getStatus());
        }
        return isSaleing;
    }

    public String getPreviewImagePath() {
        if (!CollectionUtils.isEmpty(this.productImages)) {
            return PropertyHolder.getFullImageUrl(this.productImages.get(0).getPath());
        }
        if (this.product != null && !CollectionUtils.isEmpty(this.product.getProductImages())) {
            return PropertyHolder.getFullImageUrl(this.product.getProductImages().get(0).getPath());
        }
        return "";
    }

    public String getProductFullName() {
        if (this.product != null && StringUtils.isNotBlank((CharSequence)this.product.getName())) {
            return this.product.getName() + BLANK + this.getAttributes();
        }
        return "";
    }

    public String getAttributes() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.attribute1)) {
            sb.append(this.attribute1).append(BLANK);
        }
        if (StringUtils.isNotBlank((CharSequence)this.attribute2)) {
            sb.append(this.attribute2).append(BLANK);
        }
        if (StringUtils.isNotBlank((CharSequence)this.attribute3)) {
            sb.append(this.attribute3).append(BLANK);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public StockStatus getStockStatus() {
        if (this.getStock() != null && this.getVirtualStock() != null && this.getWarningStock() != null && this.getOccupiedStock() != null) {
            if (this.getAvailableStockQuantity() > this.getWarningStock()) {
                return StockStatus.NORMAL;
            }
            return StockStatus.WARNING;
        }
        return null;
    }

    public Double getCashAmt() {
        return this.cashAmt;
    }

    public void setCashAmt(Double cashAmt) {
        this.cashAmt = cashAmt;
    }

    public Integer getCent() {
        return this.cent;
    }

    public void setCent(Integer cent) {
        this.cent = cent;
    }

    public Double getMergeCashAmt() {
        return this.mergeCashAmt;
    }

    public void setMergeCashAmt(Double mergeCashAmt) {
        this.mergeCashAmt = mergeCashAmt;
    }

    public Double getMergeCent() {
        return this.mergeCent;
    }

    public void setMergeCent(Double mergeCent) {
        this.mergeCent = mergeCent;
    }

    public Double getOrigCashAmt() {
        return this.origCashAmt;
    }

    public void setOrigCashAmt(Double origCashAmt) {
        this.origCashAmt = origCashAmt;
    }

    public Integer getOrigCent() {
        return this.origCent;
    }

    public void setOrigCent(Integer origCent) {
        this.origCent = origCent;
    }

    public Double getOrigMergeCashAmt() {
        return this.origMergeCashAmt;
    }

    public void setOrigMergeCashAmt(Double origMergeCashAmt) {
        this.origMergeCashAmt = origMergeCashAmt;
    }

    public Double getOrigMergeCent() {
        return this.origMergeCent;
    }

    public void setOrigMergeCent(Double origMergeCent) {
        this.origMergeCent = origMergeCent;
    }

    public static String getBlank() {
        return BLANK;
    }

    public String getSupplierProdCode() {
        return this.supplierProdCode;
    }

    public void setSupplierProdCode(String supplierProdCode) {
        this.supplierProdCode = supplierProdCode;
    }

    public Boolean getDisplayInlist() {
        return this.displayInlist;
    }

    public void setDisplayInlist(Boolean displayInlist) {
        this.displayInlist = displayInlist;
    }

    public String getSupplierName() {
        return this.supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public DictWarehouse getWareHouse() {
        return this.wareHouse;
    }

    public void setWareHouse(DictWarehouse wareHouse) {
        this.wareHouse = wareHouse;
    }

    public List<String> getCanDos() {
        return this.canDos;
    }

    public void setCanDos(List<String> canDos) {
        this.canDos = canDos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StockStatus {
        NORMAL("\u6b63\u5e38"),
        WARNING("\u9884\u8b66");

        private final String label;

        private StockStatus(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ENABLED("\u542f\u7528"),
        DISABLED("\u505c\u7528");

        private final String label;

        private Status(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

