/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.entity.wx;

import com.rocoinfo.rocomall.entity.wx.Menu;
import com.rocoinfo.rocomall.enumconst.MenuEventType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WxMenu {
    private String type;
    private String name;
    private String key;
    private String url;
    private List<WxMenu> subMenuList;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static WxMenu valueOf(Menu menu) {
        WxMenu wxMenu = null;
        if (menu != null) {
            wxMenu = new WxMenu();
            wxMenu.setName(menu.getMenuName());
            wxMenu.setType(menu.getMenuType().toString());
            if (MenuEventType.click.equals((Object)menu.getMenuType())) {
                String key = menu.getAct() + "_" + menu.getBoundAccess();
                wxMenu.setKey(key);
            } else {
                wxMenu.setUrl(menu.getLinkUrl());
            }
        }
        return wxMenu;
    }

    public void addSubMenu(WxMenu subMenu) {
        if (subMenu != null) {
            if (this.subMenuList == null) {
                this.subMenuList = new ArrayList<WxMenu>();
            }
            this.subMenuList.add(subMenu);
        }
    }

    public List<WxMenu> getSubMenuList() {
        return this.subMenuList;
    }

    public void setSubMenuList(List<WxMenu> subMenuList) {
        this.subMenuList = subMenuList;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

