/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.repository.SmsSendInfoDao;
import com.rocoinfo.rocomall.utils.HttpUtils;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsService {
    private static Logger logger = LoggerFactory.getLogger(SmsService.class);
    @Autowired
    private SmsSendInfoDao smsSendInfoDao;

    public boolean sendSms(String content, String ... phoneNumbers) {
        content = PropertyHolder.getSmsContentPrefix() + content;
        String logType = "send msg";
        if (StringUtils.isEmpty((CharSequence)PropertyHolder.getSmsAppId())) {
            NameValuePair[] params = new NameValuePair[]{new BasicNameValuePair("type", "4"), new BasicNameValuePair("SignType", "00"), new BasicNameValuePair("mobile", phoneNumbers[0]), new BasicNameValuePair("msg", content)};
            String status = HttpUtils.get(PropertyHolder.getSmsGateWay(), params);
            logger.info("{} user rocoinfo interface ,content:{},phones:{},result:{}", new Object[]{logType, content, phoneNumbers[0], status});
            return "\"0\"".equals(status);
        }
        if (phoneNumbers.length > 100) {
            throw new ServiceException("\u624b\u673a\u53f7\u6700\u591a\u4e0d\u80fd\u8d85\u8fc7100\u4e2a");
        }
        String version = "1.0";
        String joinPhoneNumbersString = StringUtils.join((Object[])phoneNumbers, (String)",");
        String appId = PropertyHolder.getSmsAppId();
        String appSecret = PropertyHolder.getSmsAppSecret();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String batchNo = UUID.randomUUID().toString();
        StringBuffer sb = new StringBuffer();
        sb.append(version);
        sb.append(appId).append(timestamp).append(batchNo);
        sb.append(joinPhoneNumbersString).append(content);
        sb.append(appSecret);
        String md5Value = DigestUtils.md5Hex((String)sb.toString());
        NameValuePair[] params = new NameValuePair[]{new BasicNameValuePair("version", version), new BasicNameValuePair("appId", appId), new BasicNameValuePair("timestamp", timestamp), new BasicNameValuePair("batchNo", batchNo), new BasicNameValuePair("mobileNo", joinPhoneNumbersString), new BasicNameValuePair("content", content), new BasicNameValuePair("sign", md5Value)};
        String status = HttpUtils.post(PropertyHolder.getSmsGateWay(), params);
        this.insert(joinPhoneNumbersString, content, "0".equals(status));
        logger.info("{} user newchina interface ,appId:{},appSecret:{},timestamp:{},batchNo:{},md5Value:{}", new Object[]{logType, appId, appSecret, timestamp, batchNo, md5Value});
        logger.info("{} user newchina interface ,content:{},phones:{},url:{},result:{}", new Object[]{logType, content, phoneNumbers[0], PropertyHolder.getSmsGateWay(), status});
        return true;
    }

    public void insert(String mobilePhone, String smsContent, boolean success) {
    }
}

