/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.entity.account.AdminRole;
import com.rocoinfo.rocomall.entity.account.AdminSupplier;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.Role;
import com.rocoinfo.rocomall.entity.account.RolePermission;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.repository.account.AdminRoleDao;
import com.rocoinfo.rocomall.repository.account.AdminSupplierDao;
import com.rocoinfo.rocomall.repository.account.AdminUserDao;
import com.rocoinfo.rocomall.repository.account.RoleDao;
import com.rocoinfo.rocomall.repository.account.RolePermissionDao;
import com.rocoinfo.rocomall.service.IAdminUserService;
import com.rocoinfo.rocomall.service.impl.product.SupplierService;
import com.rocoinfo.rocomall.utils.PasswordUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AdminUserService
extends CrudService<AdminUserDao, AdminUser>
implements IAdminUserService {
    @Autowired
    private AdminRoleDao adminRoleDao;
    @Autowired
    private RolePermissionDao rolePermissionDao;
    @Autowired
    private AdminSupplierDao adminSupplierDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private SupplierService supplierService;

    @Override
    public void updateLoginPassword(long adminId, String newPlainPwd) {
        if (adminId > 0L) {
            AdminUser admin = new AdminUser();
            admin.setId(adminId);
            admin.setPlainPassword(newPlainPwd);
            PasswordUtil.entryptPassword(admin);
            this.update(admin);
        }
    }

    @Override
    public boolean isLoginPasswordCorrect(String username, String loginPassword) {
        AdminUser adm = ((AdminUserDao)this.entityDao).getByUsername(username);
        if (adm == null || adm.getPassword() == null || adm.getSalt() == null || loginPassword == null) {
            return false;
        }
        return PasswordUtil.hashPassword(loginPassword, adm.getSalt()).equals(adm.getPassword());
    }

    @Override
    public boolean isUsernameRegisted(String username) {
        return ((AdminUserDao)this.entityDao).getByUsername(username) != null;
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void saveAdminAndRole(AdminUser admin) {
        this.removeNullRoles(admin);
        this.removeNullSuppliers(admin);
        if (this.isUsernameRegisted(admin.getUsername())) {
            throw new ServiceException("\u7ba1\u7406\u5458\u5df2\u5b58\u5728: " + admin.getUsername());
        }
        if (StringUtils.isNotEmpty((CharSequence)admin.getPlainPassword())) {
            PasswordUtil.entryptPassword(admin);
        }
        admin.setStatus(SwitchStatus.OPEN);
        this.insert(admin);
        if (CollectionUtils.isNotEmpty(admin.getRoles())) {
            for (Role role : admin.getRoles()) {
                this.adminRoleDao.insert(new AdminRole(admin.getId(), role.getId()));
            }
        }
        if (CollectionUtils.isNotEmpty(admin.getSuppliers())) {
            for (Supplier supplier : admin.getSuppliers()) {
                this.adminSupplierDao.insert(new AdminSupplier(admin.getId(), supplier.getId()));
            }
        }
    }

    @Override
    public void updateAdminAndRole(AdminUser admin) {
        this.removeNullRoles(admin);
        this.removeNullSuppliers(admin);
        if (StringUtils.isNotEmpty((CharSequence)admin.getPlainPassword())) {
            PasswordUtil.entryptPassword(admin);
        }
        this.adminRoleDao.deleteByAdminId(admin.getId());
        if (CollectionUtils.isNotEmpty(admin.getRoles())) {
            for (Role role : admin.getRoles()) {
                this.adminRoleDao.insert(new AdminRole(admin.getId(), role.getId()));
            }
        }
        this.adminSupplierDao.deleteByAdminId(admin.getId());
        if (CollectionUtils.isNotEmpty(admin.getSuppliers())) {
            for (Supplier supplier : admin.getSuppliers()) {
                this.adminSupplierDao.insert(new AdminSupplier(admin.getId(), supplier.getId()));
            }
        }
        this.update(admin);
    }

    @Override
    public AdminUser getAdminByUsername(String username) {
        return ((AdminUserDao)this.entityDao).getByUsername(username);
    }

    @Override
    public Role getRoleById(Long roleId) {
        for (Role role : this.getProxy().findAllRole()) {
            if (!role.getId().equals(roleId)) continue;
            return role;
        }
        return null;
    }

    @Override
    public void buildRolePermissionDetail(Role role) {
        List<RolePermission> rolePermissions = this.rolePermissionDao.findByRoleId(role.getId());
        ArrayList<String> permissions = new ArrayList<String>(rolePermissions.size());
        for (RolePermission rolePermission : rolePermissions) {
            permissions.add(rolePermission.getPermission());
        }
        role.setPermissions(permissions);
    }

    @Override
    public void buildAdminPermissionDetail(AdminUser admin) {
        List<Long> roleIds = this.adminRoleDao.findRoleIdsByAdminId(admin.getId());
        ArrayList<Role> roles = new ArrayList<Role>(roleIds.size());
        for (Long roleId : roleIds) {
            Role role = this.getRoleById(roleId);
            this.buildRolePermissionDetail(role);
            roles.add(role);
        }
        admin.setRoles(roles);
        List<Supplier> suppliers = this.supplierService.findUseableSupplysByAdminId(admin.getId());
        if (suppliers == null) {
            suppliers = Collections.emptyList();
        }
        admin.setSuppliers(suppliers);
    }

    @Override
    public List<Role> findAllRole() {
        return this.roleDao.findAll();
    }

    @Override
    @CacheEvict(value={"cache"}, key="'cache.role.all'")
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void saveRoleAndPermissions(Role role) {
        this.removeNullRoles(role);
        if (role != null && StringUtils.isNotBlank((CharSequence)role.getName()) && this.roleDao.countName(role) > 0L) {
            throw new IllegalArgumentException("\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        this.roleDao.insert(role);
        if (CollectionUtils.isNotEmpty(role.getPermissions())) {
            for (String perm : role.getPermissions()) {
                this.rolePermissionDao.insert(new RolePermission(role.getId(), perm));
            }
        }
    }

    @Override
    @CacheEvict(value={"cache"}, key="'cache.role.all'")
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void updateRoleAndPermissions(Role role) {
        this.removeNullRoles(role);
        if (this.roleDao.countName(role) > 0L) {
            throw new IllegalArgumentException("\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        this.roleDao.update(role);
        this.rolePermissionDao.deleteByRoleId(role.getId());
        if (CollectionUtils.isNotEmpty(role.getPermissions())) {
            for (String perm : role.getPermissions()) {
                this.rolePermissionDao.insert(new RolePermission(role.getId(), perm));
            }
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    @CacheEvict(value={"cache"}, key="'cache.role.all'")
    public void deleteRoleAndPermissionByRoleId(Long roleId) {
        this.adminRoleDao.deleteByRoleId(roleId);
        this.rolePermissionDao.deleteByRoleId(roleId);
        this.roleDao.deleteById(roleId);
    }

    @Override
    public void switchAdminStatus(Long userId, SwitchStatus status) {
        AdminUser admin = new AdminUser();
        admin.setId(userId);
        admin.setStatus(status);
        this.update(admin);
    }

    private void removeNullRoles(AdminUser user) {
        if (user != null && Collections3.isNotEmpty(user.getRoles())) {
            Iterator<Role> iterator = user.getRoles().iterator();
            while (iterator.hasNext()) {
                Role role = iterator.next();
                if (role != null && role.getId() != null) continue;
                iterator.remove();
            }
        }
    }

    private void removeNullSuppliers(AdminUser user) {
        if (user != null && Collections3.isNotEmpty(user.getSuppliers())) {
            Iterator<Supplier> iterator = user.getSuppliers().iterator();
            while (iterator.hasNext()) {
                Supplier supplier = iterator.next();
                if (supplier != null && supplier.getId() != null) continue;
                iterator.remove();
            }
        }
    }

    private void removeNullRoles(Role role) {
        if (role != null && Collections3.isNotEmpty(role.getPermissions())) {
            Iterator<String> iterator = role.getPermissions().iterator();
            while (iterator.hasNext()) {
                String permission = iterator.next();
                if (!StringUtils.isBlank((CharSequence)permission)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public List<AdminUser> findAllWithStatus(SwitchStatus status) {
        List<AdminUser> all = this.findAll();
        if (status == null) {
            return all;
        }
        ArrayList<AdminUser> opens = new ArrayList<AdminUser>();
        ArrayList<AdminUser> locks = new ArrayList<AdminUser>();
        for (AdminUser advType : all) {
            if (advType.getStatus() == SwitchStatus.OPEN) {
                opens.add(advType);
                continue;
            }
            locks.add(advType);
        }
        if (status == SwitchStatus.OPEN) {
            return opens;
        }
        return locks;
    }

    public AdminUserService getProxy() {
        return (AdminUserService)AopContext.currentProxy();
    }
}

