/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.BannerAdv;
import com.rocoinfo.rocomall.repository.AdvertiseDao;
import com.rocoinfo.rocomall.service.IAdvertiseService;
import com.rocoinfo.rocomall.service.IUploadService;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional(isolation=Isolation.REPEATABLE_READ)
public class AdvertiseService
extends CrudService<AdvertiseDao, BannerAdv>
implements IAdvertiseService {
    @Autowired
    private IUploadService uploadService;

    @Override
    public List<BannerAdv> findBannerAdvList(int visibleFlag) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("visibleFlag", visibleFlag);
        return ((AdvertiseDao)this.entityDao).findBanners(paramMap);
    }

    @Override
    public void insert(BannerAdv banner) {
        if (StringUtils.isNotBlank((CharSequence)banner.getImgUrl())) {
            banner.setImgUrl(this.uploadService.submitPath(banner.getImgUrl()));
        }
        super.insert(banner);
    }

    @Override
    public void update(BannerAdv banner) {
        BannerAdv oldBannerAdv = (BannerAdv)this.getById(banner.getId());
        if (oldBannerAdv == null) {
            throw new ServiceException("\u8981\u4fee\u6539\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728. id=" + banner.getId());
        }
        if (banner.getImgUrl() != null) {
            if (!banner.getImgUrl().equals(oldBannerAdv.getImgUrl())) {
                this.uploadService.delete(oldBannerAdv.getImgUrl());
            }
            banner.setImgUrl(this.uploadService.submitPath(banner.getImgUrl()));
        }
        super.update(banner);
    }

    @Override
    public void deleteById(Long advId) {
        BannerAdv bannerAdv = (BannerAdv)this.getById(advId);
        if (bannerAdv != null) {
            super.deleteById(advId);
            this.uploadService.delete(bannerAdv.getImgUrl());
        }
    }

    @Override
    public void modifyBannerAdvVisibility(boolean visible, Integer ... advIds) {
        if (!ArrayUtils.isEmpty((Object[])advIds)) {
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("visible", visible);
            paramMap.put("advIds", advIds);
            ((AdvertiseDao)this.entityDao).modifyBannerAdvVisibility(paramMap);
        }
    }

    @Override
    @Deprecated
    public void batchModifyBannerAdvSeq(Integer[] advIds, Integer[] seqs) {
        if (ArrayUtils.isEmpty((Object[])advIds) || ArrayUtils.isEmpty((Object[])seqs) || advIds.length != seqs.length) {
            throw new IllegalArgumentException("\u6279\u91cf\u4fee\u6539Banner\u5e7f\u544a\u987a\u5e8f\u65f6\uff0cadvIds\u4e0eseqs\u53c2\u6570\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e76\u4e14\u6570\u7ec4\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4");
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("advIds", advIds);
        paramMap.put("seqs", seqs);
        ((AdvertiseDao)this.entityDao).batchModifyBannerAdvSeq(paramMap);
    }

    private AdvertiseService getProxy() {
        return (AdvertiseService)AopContext.currentProxy();
    }
}

