/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.XhEditorUploadDto;
import com.rocoinfo.rocomall.service.ISequenceService;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.impl.SequenceService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.HtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Transactional(isolation=Isolation.SERIALIZABLE)
public class UploadService
implements IUploadService {
    private Logger logger = LoggerFactory.getLogger(UploadService.class);
    public static ThreadLocal<Map<String, Object>> uploadThreadLocal = new ThreadLocal();
    @Value(value="${upload.dir}")
    private String uploadDir;
    @Value(value="${image.base.url}")
    private String imageBaseUrl;
    @Autowired
    private ISequenceService sequenceService;
    private static final SimpleDateFormat DATE_PATH_SDF = new SimpleDateFormat("yyyy/MM/dd");
    private static final String TMP_BASE_PATH = "tmp/";
    private static final Pattern tmpImgSrcPattern = Pattern.compile(" src=(\"|')(tmp/([^\\\\1]|1)+?)\\1");
    private static final Pattern imgSrcPattern = Pattern.compile(" src=(\"|')(([^\\\\1]|1)+?)\\1");
    private int maxUploadBytes = 0x500000;
    protected static Map<String, ThumbnailProperty[]> thumbnailPropertyMap;
    protected static List<String> XH_EDITOR_ALLOWED_TYPE;
    public static final String REQUEST_KEY = "request";
    public static final String USER_ID = "userid";

    public static void setInfoInThreadLocal(String key, Object value) {
        Map<String, Object> map = uploadThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            uploadThreadLocal.set(map);
        }
        map.put(key, value);
    }

    public static void setRequestAndUserId(HttpServletRequest req, Long userId) {
        UploadService.setInfoInThreadLocal(REQUEST_KEY, req);
        UploadService.setInfoInThreadLocal(USER_ID, userId);
    }

    protected Map<String, ThumbnailProperty[]> initThumbnailPropertyMap() {
        return Maps.newHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ThumbnailProperty[] getThumbnailPropertyByType(UploadCategory uploadCategory) {
        if (thumbnailPropertyMap != null) return thumbnailPropertyMap.get(uploadCategory.getPath());
        Class<ThumbnailProperty> clazz = ThumbnailProperty.class;
        synchronized (ThumbnailProperty.class) {
            if (thumbnailPropertyMap != null) return thumbnailPropertyMap.get(uploadCategory.getPath());
            thumbnailPropertyMap = this.initThumbnailPropertyMap();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return thumbnailPropertyMap.get(uploadCategory.getPath());
        }
    }

    @Override
    public String upload(MultipartFile file, UploadCategory uploadCategory) {
        InputStream input;
        this.validateUploadFile(file, uploadCategory);
        try {
            input = file.getInputStream();
        }
        catch (IOException e) {
            this.logger.debug("\u8bfb\u53d6\u4e0a\u4f20\u6587\u4ef6\u8f93\u5165\u6d41\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new ServiceException("\u8bfb\u53d6\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u9519\u8bef");
        }
        String ext = FilenameUtils.getExtension((String)file.getOriginalFilename());
        return this.saveTmp(input, ext, uploadCategory.getPath());
    }

    @Override
    public String upload(InputStream stream, UploadCategory uploadCategory, String ext) {
        return this.saveTmp(stream, ext, uploadCategory.getPath());
    }

    public void validateUploadFile(MultipartFile file, UploadCategory uploadCategory) {
        if (file.isEmpty()) {
            throw new ServiceException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)file.getOriginalFilename())) {
            throw new ServiceException("\u4e0a\u4f20\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String ext = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (StringUtils.isBlank((CharSequence)ext)) {
            throw new ServiceException("\u4e0a\u4f20\u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (file.getSize() > (long)this.maxUploadBytes) {
            throw new ServiceException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e " + FileUtils.byteCountToDisplaySize((long)this.maxUploadBytes));
        }
    }

    @Override
    public String submitPath(String tmpPath) {
        this.moveFileBefore(tmpPath);
        tmpPath = this.mockImageBasePath(tmpPath);
        if (!tmpPath.startsWith(TMP_BASE_PATH)) {
            return tmpPath;
        }
        File tmpFile = new File(this.uploadDir, tmpPath);
        this.logger.info("\u6587\u4ef6\u96f6\u65f6\u5730\u5740:{}", (Object)tmpFile.getAbsolutePath());
        String destPath = tmpPath.substring(TMP_BASE_PATH.length());
        File destFile = new File(this.uploadDir, destPath);
        if (!tmpFile.exists() && destFile.exists()) {
            return destPath;
        }
        if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new ServiceException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25" + destFile.getParentFile().getAbsolutePath());
        }
        try {
            this.generateThumbnailImage(tmpFile, destPath);
            if (this.parseCatalogType(tmpPath).getPath().toLowerCase().endsWith("import")) {
                FileUtils.copyFile((File)tmpFile, (File)destFile);
            } else {
                FileUtils.moveFile((File)tmpFile, (File)destFile);
            }
            this.moveFileAfter(destFile, tmpPath);
        }
        catch (IOException e) {
            this.logger.warn("\u79fb\u52a8\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u79fb\u52a8\u6587\u4ef6\u5931\u8d25");
        }
        return destPath;
    }

    protected void moveFileBefore(String tmpPath) {
    }

    protected void moveFileAfter(File file, String tmpPath) {
        try {
            UploadCategory category = this.parseCatalogType(tmpPath);
            if (!category.getPath().toLowerCase().endsWith("import")) {
                // empty if block
            }
            String ip = null;
            Long userId = null;
            Map<String, Object> map = uploadThreadLocal.get();
            if (map != null) {
                HttpServletRequest request = (HttpServletRequest)map.get(REQUEST_KEY);
                if (request != null) {
                    ip = request.getRemoteAddr();
                }
                userId = (Long)map.get(USER_ID);
            }
            this.logger.info("upload excel .\u4e0a\u4f20\u65f6\u95f4\u3010{}\u3011,\u7528\u6237id\u3010{}\u3011.\u7c7b\u578b\u3010{}\u3011.\u7528\u6237ip\u3010{}\u3011.\u6587\u4ef6\u8def\u5f84\u3010{}\u3011", new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), userId, category, ip, file.getAbsolutePath()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public File submitPathAndGetfile(String path) {
        String newPath = this.submitPath(path);
        return new File(this.uploadDir, newPath);
    }

    public void generateThumbnailImage(File tmpFile, String destPath) throws IOException {
        ThumbnailProperty[] propertys = this.getThumbnailPropertyByType(this.parseCatalogType(destPath));
        if (propertys != null) {
            for (ThumbnailProperty p : propertys) {
                Thumbnails.of((File[])new File[]{tmpFile}).size(p.getWidth(), p.getHeight()).toFile(new File(this.uploadDir, this.getFilePathByType(p, destPath)));
            }
        }
    }

    private String getFilePathByType(ThumbnailProperty p, String destPath) {
        return destPath + "." + p.getWidth() + "_" + p.getHeight() + ".jpg";
    }

    @Override
    public UploadCategory parseCatalogType(String path) {
        path = this.getDbPath(path);
        String type = StringUtils.split((String)path, (String)"/")[0];
        return UploadCategory.parsePathToCategory(type);
    }

    @Override
    public String submitHtml(String html) {
        if (StringUtils.isNotBlank((CharSequence)html)) {
            html = HtmlUtils.htmlUnescape((String)html);
            StringBuilder newHtml = new StringBuilder();
            int pos = 0;
            Matcher matcher = imgSrcPattern.matcher(html);
            while (matcher.find()) {
                String src = matcher.group(2);
                if (!src.startsWith(this.imageBaseUrl)) continue;
                String path = this.mockImageBasePath(src);
                newHtml.append(html.substring(pos, matcher.start(2)));
                newHtml.append(PropertyHolder.getFullImageUrl(this.submitPath(path)));
                pos = matcher.end(2);
            }
            newHtml.append(html.substring(pos));
            return newHtml.toString();
        }
        return html;
    }

    private String mockImageBasePath(String url) {
        if (!url.startsWith(this.imageBaseUrl)) {
            return url;
        }
        return url.substring(this.imageBaseUrl.length());
    }

    private String getDbPath(String path) {
        if ((path = this.mockImageBasePath(path)).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith(TMP_BASE_PATH)) {
            path = path.substring(TMP_BASE_PATH.length());
        }
        return path;
    }

    private String mockSubmitPath(String tmpPath) {
        if (!tmpPath.startsWith(TMP_BASE_PATH)) {
            return tmpPath;
        }
        return tmpPath.substring(TMP_BASE_PATH.length());
    }

    @Override
    public String updateHtml(String oldHtml, String newHtml) {
        if (StringUtils.isNotBlank((CharSequence)oldHtml)) {
            List<String> pathsInOldHtml = this.findPathsInHtml(oldHtml);
            List<String> pathsInNewHtml = this.findPathsInHtml(newHtml);
            for (String oldPath : pathsInOldHtml) {
                if (pathsInNewHtml.contains(oldPath)) continue;
                this.delete(oldPath);
            }
        }
        return this.submitHtml(newHtml);
    }

    @Override
    public List<String> deleteByPathInHtml(String html) {
        if (StringUtils.isNotBlank((CharSequence)html)) {
            List<String> paths = this.findPathsInHtml(html);
            for (String path : paths) {
                this.delete(path);
            }
            return paths;
        }
        return Collections.emptyList();
    }

    private List<String> findPathsInHtml(String html) {
        ArrayList<String> paths = new ArrayList<String>();
        Matcher matcher = imgSrcPattern.matcher(html);
        while (matcher.find()) {
            String src = matcher.group(2);
            if (!src.startsWith(this.imageBaseUrl)) continue;
            paths.add(this.mockImageBasePath(src));
        }
        return paths;
    }

    @Override
    public void delete(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        char first = path.charAt(0);
        if (first == '/' || first == '.') {
            return;
        }
        File file = new File(this.uploadDir, path);
        if (file.exists() && !file.delete()) {
            this.logger.warn("\u5220\u9664 {} \u5931\u8d25", (Object)file.getAbsolutePath());
        }
        this.deleteThumbnailImage(path);
    }

    public void deleteThumbnailImage(String path) {
        ThumbnailProperty[] propertys = this.getThumbnailPropertyByType(this.parseCatalogType(path));
        File file = null;
        if (propertys != null) {
            for (ThumbnailProperty p : propertys) {
                file = new File(this.uploadDir, this.getFilePathByType(p, path));
                if (!file.exists() || file.delete()) continue;
                this.logger.warn("\u5220\u9664 {} \u5931\u8d25", (Object)file.getAbsolutePath());
            }
        }
    }

    private String saveTmp(InputStream input, String ext, String categoryPath) {
        Assert.state((boolean)StringUtils.isNotBlank((CharSequence)ext));
        Assert.notNull((Object)input);
        String path = TMP_BASE_PATH + categoryPath + "/" + DATE_PATH_SDF.format(new Date()) + "/" + this.sequenceService.getNextVal(SequenceService.SequenceTable.UPLOAD) + "." + ext;
        this.save(path, input);
        return path;
    }

    private void save(String path, InputStream input) {
        Assert.state((boolean)StringUtils.isNotBlank((CharSequence)this.uploadDir));
        Assert.state((boolean)StringUtils.isNotBlank((CharSequence)path));
        BufferedInputStream bufInput = null;
        BufferedOutputStream bufOut = null;
        try {
            File dest = new File(this.uploadDir, path);
            if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                throw new ServiceException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25 " + dest.getParentFile().getAbsolutePath());
            }
            bufInput = new BufferedInputStream(input);
            bufOut = new BufferedOutputStream(new FileOutputStream(dest));
            IOUtils.copy((InputStream)bufInput, (OutputStream)bufOut);
        }
        catch (IOException e) {
            try {
                this.logger.warn("\u4fdd\u5b58\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                throw new ServiceException("\u4fdd\u5b58\u6587\u4ef6\u51fa\u9519");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufOut);
                IOUtils.closeQuietly(bufInput);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bufOut);
        IOUtils.closeQuietly((InputStream)bufInput);
    }

    @Override
    public void scheduleCleanTmpFile() throws ParseException, IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(5, -1);
        Date deleteBefore = calendar.getTime();
        File tmp = new File(this.uploadDir, TMP_BASE_PATH);
        if (tmp.exists()) {
            for (File catalogDir : tmp.listFiles()) {
                if (catalogDir.isHidden() || !catalogDir.isDirectory()) continue;
                for (File yearDir : catalogDir.listFiles()) {
                    if (yearDir.isHidden() || !yearDir.isDirectory()) continue;
                    for (File monthDir : yearDir.listFiles()) {
                        if (monthDir.isHidden() || !monthDir.isDirectory()) continue;
                        for (File dateDir : monthDir.listFiles()) {
                            Date dirDate;
                            if (dateDir.isHidden() || !dateDir.isDirectory() || (dirDate = DATE_PATH_SDF.parse(yearDir.getName() + "/" + monthDir.getName() + "/" + dateDir.getName())).getTime() >= deleteBefore.getTime()) continue;
                            FileUtils.deleteDirectory((File)dateDir);
                        }
                    }
                }
            }
        }
    }

    @Override
    public XhEditorUploadDto xhEditorUpload(MultipartFile file, UploadCategory uploadCategory) {
        XhEditorUploadDto dto = new XhEditorUploadDto();
        String ext = FilenameUtils.getExtension((String)file.getOriginalFilename()).toLowerCase();
        if (!XH_EDITOR_ALLOWED_TYPE.contains(ext)) {
            dto.setErr("\u53ea\u53ef\u4e0a\u4f20 " + XH_EDITOR_ALLOWED_TYPE);
            return dto;
        }
        try {
            String path = this.upload(file, uploadCategory);
            dto.setMsg(PropertyHolder.getFullImageUrl(path));
        }
        catch (ServiceException e) {
            dto.setErr(e.getMessage());
        }
        return dto;
    }

    @Override
    public String updateFile(String path, String oldPath) {
        if (StringUtils.isNotBlank((CharSequence)oldPath)) {
            this.delete(oldPath);
        }
        return this.submitPath(path);
    }

    @Override
    public File getFileByPath(String path) {
        path = this.mockImageBasePath(path);
        return new File(this.uploadDir, path);
    }

    static {
        XH_EDITOR_ALLOWED_TYPE = Arrays.asList("jpg", "jpeg", "gif", "png");
    }

    public static class ThumbnailProperty {
        private int width;
        private int height;
        private int size;

        public ThumbnailProperty(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public ThumbnailProperty(int width, int height, int size) {
            this.width = width;
            this.height = height;
            this.size = size;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UploadCategory {
        PRODUCT("product"),
        USER("user"),
        BRAND("brand"),
        AD("ad"),
        LOGO("logo"),
        QRCODE("qrcode"),
        CATALOG("catalog"),
        USER_LEVEL("userLevel"),
        PLATFORM_ICON("platformIcon"),
        VIRTUALCARD_IMPORT("virtualcardImport", "com.rocoinfo.rocomall.dto.admin.VirtualProductExcelDto"),
        ORDER_IMPORT("orderImport", "com.rocoinfo.rocomall.dto.admin.OrderBitchSendImportExcelDto"),
        CENT_APPLY_IMPORT("centApplyImport"),
        DISTRIBUTION_ORDER_IMPORT("distributionOrderImport", "com.rocoinfo.rocomall.dto.admin.LogisticInfo"),
        COUPONS_PROVIDE_IMPORT("couponsProvideImport", "com.rocoinfo.rocomall.dto.CouponsInfoDto");

        private String path;
        private String className;

        private UploadCategory(String path) {
            this.path = path;
        }

        private UploadCategory(String path, String className) {
            this.path = path;
            this.className = className;
        }

        public String getPath() {
            return this.path;
        }

        public String getClassName() {
            return this.className;
        }

        public static UploadCategory parsePathToCategory(String path) {
            for (UploadCategory category : UploadCategory.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)path, (CharSequence)category.getPath())) continue;
                return category;
            }
            return null;
        }
    }
}

