/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.UserBind;
import com.rocoinfo.rocomall.repository.account.UserBindDao;
import com.rocoinfo.rocomall.service.IUserBindService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class UserBindService
extends CrudService<UserBindDao, UserBind>
implements IUserBindService {
    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public StatusDto<String> bindUser(UserBind userBind) {
        if (userBind == null || userBind.getOuid() == null || userBind.getPlatForm() == null || userBind.getUserId() == null) {
            return StatusDto.buildFailureStatusDto("\u7ed1\u5b9a\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Long boundedUserId = this.getBindUserIdByPlatformCodeAndOuid(userBind.getPlatForm().getCode(), userBind.getOuid());
        if (boundedUserId != null) {
            return StatusDto.buildFailureStatusDto(userBind.getPlatForm().getCode() + "\u7684\u8d26\u6237\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u79ef\u5206\u5e73\u53f0\u7528\u6237");
        }
        String boundedOuid = this.getBindOuidByPlatformCodeAndUserId(userBind.getPlatForm().getCode(), userBind.getUserId());
        if (!StringUtils.isEmpty((Object)boundedOuid)) {
            return StatusDto.buildFailureStatusDto("\u60a8\u5df2\u6709\u5176\u5b83\u8d26\u53f7\u7ed1\u5b9a\u5230\u79ef\u5206\u5e73\u53f0");
        }
        try {
            ((UserBindDao)this.entityDao).insert(userBind);
            return StatusDto.buildSuccessStatusDto("\u8d26\u6237\u7ed1\u5b9a\u6210\u529f!");
        }
        catch (Exception e) {
            return StatusDto.buildFailureStatusDto("\u7ed1\u5b9a\u5931\u8d25\uff0c\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
    }

    @Override
    public boolean isBoundUserId(String platformCode, String ouid) {
        return ((UserBindDao)this.entityDao).getBindUserIdByPlatformCodeAndOuid(platformCode, ouid) != null;
    }

    @Override
    public List<UserBind> findBoundOpenedPlatformByUserId(Long userId) {
        return ((UserBindDao)this.entityDao).findBoundOpenedPlatformByUserId(userId);
    }

    @Override
    public Long getBindUserIdByPlatformCodeAndOuid(String platformCode, String ouid) {
        return ((UserBindDao)this.entityDao).getBindUserIdByPlatformCodeAndOuid(platformCode, ouid);
    }

    @Override
    public Long getBindUserIdByPlatformIdAndOuid(Long platformId, String ouid) {
        return ((UserBindDao)this.entityDao).getBindUserIdByPlatformIdAndOuid(platformId, ouid);
    }

    @Override
    public String getBindOuidByPlatformCodeAndUserId(String platformCode, Long userId) {
        return ((UserBindDao)this.entityDao).getBindOuidByPlatformCodeAndUserId(platformCode, userId);
    }

    @Override
    public int countBoundedPlatformsByUserId(Long userId) {
        return ((UserBindDao)this.entityDao).countBoundedPlatformsByUserId(userId);
    }
}

