/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.account.UserLevel;
import com.rocoinfo.rocomall.repository.account.UserLevelDao;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.IUserLevelService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class UserLevelService
extends CrudService<UserLevelDao, UserLevel>
implements IUserLevelService {
    @Autowired
    private IUploadService uploadService;

    @Override
    protected void evictCacheEntitysHook() {
        String allUserLevelKey = StringUtils.substringBetween((String)"'cache.userlevel.all'", (String)"'");
        this.cacheManager.getCache("cache").evict((Object)allUserLevelKey);
    }

    @Override
    public List<UserLevel> findAll() {
        return super.findAll();
    }

    @Override
    public UserLevel getUserLevelByGrowth(Integer growth) {
        UserLevel userLevel = null;
        for (UserLevel level : this.findAll()) {
            if (growth < level.getCent()) continue;
            userLevel = level;
            break;
        }
        return userLevel;
    }

    @Override
    public boolean isExistLevel(String level, Integer cent) {
        return ((UserLevelDao)this.entityDao).isExistLevel(level, cent) > 0;
    }

    @Override
    public void insert(UserLevel entity) {
        if (this.isExistLevel(entity.getLevel(), null)) {
            throw new ServiceException("\u7528\u6237\u7b49\u7ea7\u5df2\u7ecf\u5b58\u5728!");
        }
        if (this.isExistLevel(null, entity.getCent())) {
            throw new ServiceException("\u79ef\u5206\u5df2\u7ecf\u5b58\u5728!");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getImgUrl())) {
            entity.setImgUrl(this.uploadService.submitPath(entity.getImgUrl()));
        }
        super.insert(entity);
    }

    @Override
    public void update(UserLevel entity) {
        UserLevel dbLevel = (UserLevel)this.getById(entity.getId());
        if (!StringUtils.equals((CharSequence)entity.getLevel(), (CharSequence)dbLevel.getLevel()) && this.isExistLevel(entity.getLevel(), null)) {
            throw new ServiceException("\u7528\u6237\u7b49\u7ea7\u5df2\u7ecf\u5b58\u5728!");
        }
        if (entity.getCent() != dbLevel.getCent() && this.isExistLevel(null, entity.getCent())) {
            throw new ServiceException("\u79ef\u5206\u5df2\u7ecf\u5b58\u5728!");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getImgUrl())) {
            entity.setImgUrl(this.uploadService.updateFile(entity.getImgUrl(), dbLevel.getImgUrl()));
        }
        super.update(entity);
    }

    public UserLevelService getProxy() {
        return (UserLevelService)AopContext.currentProxy();
    }
}

