/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.dict;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;
import com.rocoinfo.rocomall.repository.dict.DictProviceCityDao;
import com.rocoinfo.rocomall.service.dict.IDictProviceCityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Transactional
public class DictProviceCityService
extends CrudService<DictProviceCityDao, DictProviceCity>
implements IDictProviceCityService {
    @Override
    public Map<Long, DictProviceCity> loadAllDictProvCityMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (DictProviceCity provCity : this.findAll()) {
            map.put(provCity.getId(), provCity);
        }
        return map;
    }

    @Override
    public List<DictProviceCity> buildProvCityNodes(List<Long> checkedCityIdList) {
        Map<Long, DictProviceCity> allDictMap = this.loadAllDictProvCityMap();
        LinkedHashMap provMap = Maps.newLinkedHashMap();
        for (Map.Entry<Long, DictProviceCity> nodeEntry : allDictMap.entrySet()) {
            DictProviceCity parent;
            DictProviceCity provCityCounty = nodeEntry.getValue();
            if (provCityCounty.getPid() <= 0L || (parent = allDictMap.get(provCityCounty.getPid())).getPid() != 0L) continue;
            if (!provMap.containsKey(parent.getId())) {
                provMap.put(parent.getId(), parent);
            }
            parent.addChild(provCityCounty);
            if (CollectionUtils.isEmpty(checkedCityIdList) || !checkedCityIdList.contains(provCityCounty.getId())) continue;
            provCityCounty.setSelected(true);
        }
        return Lists.newArrayList(provMap.values());
    }

    @Override
    public Map<Long, List<DictProviceCity>> buildParentProvCityNodeTree(boolean isLoadNodeList, Address ... addressArray) {
        Map<Long, DictProviceCity> allProvCity;
        if (ArrayUtils.isNotEmpty((Object[])addressArray) && !CollectionUtils.isEmpty(allProvCity = this.loadAllDictProvCityMap())) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)addressArray.length);
            for (Address addr : addressArray) {
                if (addr == null || addr.getProvCity() == null) continue;
                map.put(addr.getId(), this.getParentProvCityNodeTree(allProvCity, addr.getProvCity(), isLoadNodeList));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private void createSameLevelNodeList(Collection<DictProviceCity> allProvCity, DictProviceCity curLevelProvCity) {
        ArrayList nodeList = Lists.newArrayList();
        for (DictProviceCity dict : allProvCity) {
            if (!dict.getPid().equals(curLevelProvCity.getPid())) continue;
            DictProviceCity clonedProvCity = new DictProviceCity();
            clonedProvCity.setId(dict.getId());
            clonedProvCity.setName(dict.getName());
            clonedProvCity.setDisplayOrder(dict.getDisplayOrder());
            clonedProvCity.setPid(dict.getPid());
            clonedProvCity.setDeliverFee(dict.getDeliverFee());
            clonedProvCity.setFreeLimitAmt(dict.getFreeLimitAmt());
            if (dict.getId().equals(curLevelProvCity.getId())) {
                clonedProvCity.setSelected(true);
            }
            nodeList.add(clonedProvCity);
        }
        curLevelProvCity.setCurNodeList(nodeList);
    }

    private List<DictProviceCity> getParentProvCityNodeTree(Map<Long, DictProviceCity> allProvCityMap, DictProviceCity provCity, boolean isLoadNodeList) {
        DictProviceCity dict = allProvCityMap.get(provCity.getId());
        try {
            BeanUtils.copyProperties((Object)provCity, (Object)dict);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collection<DictProviceCity> allProvCityList = allProvCityMap.values();
        if (isLoadNodeList) {
            this.createSameLevelNodeList(allProvCityList, provCity);
        }
        ArrayList parentNodes = Lists.newArrayList();
        DictProviceCity pNode = provCity;
        while (pNode.getPid() > 0L) {
            pNode = allProvCityMap.get(pNode.getPid());
            parentNodes.add(pNode);
            if (!isLoadNodeList) continue;
            this.createSameLevelNodeList(allProvCityList, pNode);
        }
        if (!parentNodes.isEmpty()) {
            Collections.reverse(parentNodes);
        }
        parentNodes.add(provCity);
        return parentNodes;
    }

    @Override
    public DictProviceCity getRootDictProviceCityById(long id) {
        DictProviceCity provCity = (DictProviceCity)super.getById(id);
        while (provCity != null && provCity.getPid() > 0L) {
            provCity = (DictProviceCity)super.getById(provCity.getPid());
        }
        return provCity;
    }

    @Override
    public List<DictProviceCity> findDictProvCitysByPid(Long pid) {
        if (pid == null) {
            return Collections.emptyList();
        }
        ArrayList provCityList = Lists.newArrayList();
        for (DictProviceCity provCity : super.findAll()) {
            if (!provCity.getPid().equals(pid)) continue;
            provCityList.add(provCity);
        }
        return provCityList;
    }

    @Override
    @Deprecated
    public void batchModifyProvCitySeqs(Integer[] ids, Integer[] seqs) {
        if (ArrayUtils.isEmpty((Object[])ids) || ArrayUtils.isEmpty((Object[])seqs) || ids.length != seqs.length) {
            throw new IllegalArgumentException("\u6279\u91cf\u4fee\u6539 \u7701\u5e02\u57fa\u7840\u6570\u636e \u987a\u5e8f\u65f6\uff0cids\u4e0eseqs\u53c2\u6570\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5e76\u4e14\u6570\u7ec4\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4");
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("ids", ids);
        paramMap.put("seqs", seqs);
        ((DictProviceCityDao)this.entityDao).batchModifyProvCitySeqs(paramMap);
    }

    @Override
    public List<DictProviceCity> loadDictProvCityList(List<Long> pids) {
        if (pids != null && pids.size() > 0) {
            return ((DictProviceCityDao)this.entityDao).findDictProvCitysByPids(pids);
        }
        return null;
    }
}

