/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.dict;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.dict.DictRankType;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.repository.dict.DictRankTypeDao;
import com.rocoinfo.rocomall.service.dict.IDictRankTypeService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DictRankTypeService
extends CrudService<DictRankTypeDao, DictRankType>
implements IDictRankTypeService {
    @Override
    public boolean isExistName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        for (DictRankType rankType : this.findAll()) {
            if (rankType == null || !rankType.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void switchStatus(Long id, Status status) {
        DictRankType rankType = new DictRankType();
        rankType.setId(id);
        rankType.setStatus(status);
        this.update(rankType);
    }

    @Override
    public List<DictRankType> findAllWithStatus(Status status) {
        List<DictRankType> all = this.findAll();
        if (status == null) {
            return all;
        }
        ArrayList<DictRankType> opens = new ArrayList<DictRankType>();
        ArrayList<DictRankType> locks = new ArrayList<DictRankType>();
        for (DictRankType rankType : all) {
            if (rankType.getStatus() == Status.OPEN) {
                opens.add(rankType);
                continue;
            }
            locks.add(rankType);
        }
        if (status == Status.OPEN) {
            return opens;
        }
        return locks;
    }
}

