/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.entity.ProductCatalog;
import com.rocoinfo.rocomall.repository.ProductCatalogDao;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.IProductCatalogService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ProductCatalogService
extends CrudService<ProductCatalogDao, ProductCatalog>
implements IProductCatalogService {
    @Autowired
    private ICatalogService catalogService;

    @Override
    public void insert(Long productId, Long catalogId) {
        super.insert(new ProductCatalog(productId, catalogId));
    }

    @Override
    public void deleteByProductId(Long productId) {
        ((ProductCatalogDao)this.entityDao).deleteByProductId(productId);
    }

    @Override
    public void deleteByProductIdAndCatalogId(Long productId, Long catalogId) {
        ((ProductCatalogDao)this.entityDao).deleteByProductIdAndCatalogId(new ProductCatalog(productId, catalogId));
    }

    @Override
    public List<Long> findCatalogIdsByProductId(Long productId) {
        return ((ProductCatalogDao)this.entityDao).findCatalogIdsByProductId(productId);
    }

    @Override
    public List<Catalog> findCatalogByProductId(Long productId) {
        List<Long> ids = this.findCatalogIdsByProductId(productId);
        ArrayList<Catalog> catalogs = new ArrayList<Catalog>(ids.size());
        for (Long id : ids) {
            Catalog catlog = (Catalog)this.catalogService.getById(id);
            if (null == catlog) continue;
            catalogs.add(catlog);
        }
        return catalogs;
    }
}

