/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.ProductImage;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.repository.ProductImageDao;
import com.rocoinfo.rocomall.service.impl.UploadService;
import com.rocoinfo.rocomall.service.product.IProductImageService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class ProductImageService
extends CrudService<ProductImageDao, ProductImage>
implements IProductImageService {
    @Autowired
    private UploadService uploadService;

    @Override
    public void insert(ProductImage productImage) {
        productImage.setPath(this.uploadService.submitPath(productImage.getPath()));
        super.insert(productImage);
    }

    public List<ProductImage> getByProductId(Long productId) {
        return ((ProductImageDao)this.entityDao).getByProductId(productId);
    }

    @Override
    public List<ProductImage> findByProductIdIn(List<Long> productIdList) {
        return ((ProductImageDao)this.entityDao).findByProductIdIn(productIdList);
    }

    @Override
    public List<ProductImage> getBySkuId(Long skuId) {
        return ((ProductImageDao)this.entityDao).getBySkuId(skuId);
    }

    @Override
    public List<ProductImage> getProductPrimaryImages(Long productId) {
        return ((ProductImageDao)this.entityDao).getProductPrimaryImages(productId);
    }

    @Override
    public void update(ProductImage productImage) {
        if (productImage.getPath() != null) {
            productImage.setPath(this.uploadService.submitPath(productImage.getPath()));
            ProductImage oldProductImage = (ProductImage)super.getById(productImage.getId());
            if (oldProductImage != null && oldProductImage.getPath() != null && !oldProductImage.getPath().equals(productImage.getPath())) {
                this.uploadService.delete(oldProductImage.getPath());
            }
        }
        super.update(productImage);
    }

    @Override
    public void batchUpdate(List<ProductImage> oldProductImages, List<ProductImage> newProductImages, Product product, Sku sku) {
        int displayOrder = 0;
        for (ProductImage productImage : newProductImages) {
            productImage.setProduct(product);
            productImage.setSku(sku);
            productImage.setDisplayOrder(displayOrder++);
            if (sku != null) {
                productImage.setImageType(ProductImage.ImageType.SKU);
            }
            if (productImage.getImageType() != null) continue;
            productImage.setImageType(ProductImage.ImageType.ATTACH);
        }
        List newProductImagesIds = Collections3.extractToList(newProductImages, (String)"id");
        for (ProductImage oldProductImage : oldProductImages) {
            if (newProductImagesIds.contains(oldProductImage.getId())) continue;
            this.delete(oldProductImage);
        }
        int i = 0;
        for (ProductImage image : newProductImages) {
            image.setDisplayOrder(i);
            ++i;
            if (image.getId() == null) {
                this.insert(image);
                continue;
            }
            this.update(image);
        }
    }

    @Override
    public void batchUpdate(List<ProductImage> oldProductImages, List<ProductImage> newProductImages, Product product) {
        this.batchUpdate(oldProductImages, newProductImages, product, null);
    }

    @Override
    public void deleteById(Long id) {
        this.delete((ProductImage)super.getById(id));
    }

    public void delete(ProductImage productImage) {
        Assert.notNull((Object)productImage.getId());
        super.deleteById(productImage.getId());
        this.uploadService.delete(productImage.getPath());
    }
}

