/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Brand;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.entity.ProdTemp;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.ProductImage;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.entity.account.AdminLog;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.ProdTempDao;
import com.rocoinfo.rocomall.repository.ProductDao;
import com.rocoinfo.rocomall.repository.SkuDao;
import com.rocoinfo.rocomall.service.IAdminLogService;
import com.rocoinfo.rocomall.service.product.IBrandService;
import com.rocoinfo.rocomall.service.product.IDescriptionService;
import com.rocoinfo.rocomall.service.product.IProductCatalogService;
import com.rocoinfo.rocomall.service.product.IProductImageService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.service.product.ISkuMetaService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ProductService
extends CrudService<ProductDao, Product>
implements IProductService {
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private IDescriptionService descriptionService;
    @Autowired
    private ISkuMetaService skuMetaService;
    @Autowired
    private ISkuService skuService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IProductImageService productImageService;
    @Autowired
    private SkuDao skuDao;
    @Autowired
    private ProdTempDao prodTempDao;
    @Autowired
    private IProductCatalogService productCatalogService;
    @Autowired
    private IAdminLogService adminLogService;

    @Override
    public void buildDetail(Product product) {
        product.setBrand((Brand)this.brandService.getById(product.getBrand().getId()));
        List<Catalog> catalogs = this.productCatalogService.findCatalogByProductId(product.getId());
        if (CollectionUtils.isNotEmpty(catalogs)) {
            product.setCatalogs(catalogs);
        }
        product.setSupplier((Supplier)this.supplierService.getById(product.getSupplier().getId()));
        product.setProductImages(this.productImageService.getProductPrimaryImages(product.getId()));
        product.setSkuMeta(this.skuMetaService.getByProductIdAndDictMeta(product.getId()));
        List<Sku> skus = this.skuDao.getByProductId(product.getId());
        product.setSkus(skus);
        for (Sku sku : skus) {
            sku.setProductImages(this.productImageService.getBySkuId(sku.getId()));
        }
        product.setDescription(this.descriptionService.findByProductId(product.getId()));
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void create(Product product, Long userId) {
        List<ProductImage> mainImages;
        if (!product.getListTime().before(product.getDelistTime())) {
            throw new ServiceException("\u4e0b\u67b6\u65f6\u95f4\u5e94\u8be5\u5927\u4e8e\u4e0a\u67b6\u65f6\u95f4");
        }
        if (Collections3.isEmpty(product.getSkus())) {
            throw new ServiceException("\u5b50\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (product.getDescription() == null) {
            throw new ServiceException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (product.getVisual().booleanValue() && product.getPutType() == null) {
            throw new ServiceException("\u865a\u62df\u5546\u54c1\u5fc5\u987b\u9009\u62e9\u6295\u653e\u65b9\u5f0f");
        }
        if (!product.getVisual().booleanValue()) {
            product.setPutType(null);
        }
        this.updateProductLogicValue(product, true);
        super.insert(product);
        if (product.getCatalogs() != null) {
            for (Catalog catalog : product.getCatalogs()) {
                this.productCatalogService.insert(product.getId(), catalog.getId());
            }
        }
        if ((mainImages = product.getProductImages()) != null) {
            int index = 0;
            for (ProductImage image : mainImages) {
                if (StringUtils.isBlank((CharSequence)image.getPath())) continue;
                image.setDisplayOrder(index);
                ++index;
                image.setProduct(product);
                if (image.getImageType() == null) {
                    image.setImageType(ProductImage.ImageType.ATTACH);
                }
                this.productImageService.insert(image);
            }
        }
        product.getDescription().setProductId(product.getId());
        this.descriptionService.insert(product.getDescription());
        if (product.getSkuMeta() != null) {
            product.getSkuMeta().setProduct(product);
            this.skuMetaService.insert(product.getSkuMeta());
        }
        int i = 0;
        for (Sku sku : product.getSkus()) {
            sku.setCode(product.getId() + StringUtils.leftPad((String)String.valueOf(i + 1), (int)2, (char)'0'));
            ++i;
            this.skuService.insert(sku);
        }
        this.insertAdminLog(product.getId(), AdminLog.Action.NEW, userId);
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public void update(Product product, Long userId) {
        Product oldProduct;
        if (product.getId() == null) {
            throw new ServiceException("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (product.getVisual().booleanValue() && product.getPutType() == null) {
            throw new ServiceException("\u865a\u62df\u5546\u54c1\u5fc5\u987b\u9009\u62e9\u6295\u653e\u65b9\u5f0f");
        }
        if (!product.getVisual().booleanValue()) {
            product.setPutType(null);
        }
        if ((oldProduct = (Product)((ProductDao)this.entityDao).getById(product.getId())).getStatus() != Product.Status.DRAFT && !this.canChangeStatus(oldProduct.getStatus(), Product.Status.DRAFT)) {
            throw new ServiceException("\u5f53\u524d\u72b6\u6001 " + oldProduct.getStatus().getLabel() + " \u4e0d\u53ef\u7f16\u8f91");
        }
        product.setStatus(Product.Status.DRAFT);
        if (!product.getListTime().before(product.getDelistTime())) {
            throw new ServiceException("\u4e0b\u67b6\u65f6\u95f4\u5e94\u8be5\u5927\u4e8e\u4e0a\u67b6\u65f6\u95f4");
        }
        this.updateProductLogicValue(product, false);
        super.update(product);
        if (CollectionUtils.isNotEmpty(product.getCatalogs())) {
            this.productCatalogService.deleteByProductId(product.getId());
            for (Catalog catalog : product.getCatalogs()) {
                this.productCatalogService.insert(product.getId(), catalog.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(product.getProductImages())) {
            List<ProductImage> oldProductImages = this.productImageService.getProductPrimaryImages(product.getId());
            this.productImageService.batchUpdate(oldProductImages, product.getProductImages(), product);
        }
        if (product.getDescription() != null) {
            product.getDescription().setProductId(product.getId());
            this.descriptionService.update(product.getDescription());
        }
        if (product.getSkuMeta() != null) {
            this.skuMetaService.update(product.getSkuMeta());
        }
        if (product.getSkus() != null) {
            for (Sku sku : product.getSkus()) {
                sku.setProduct(product);
                this.skuService.update(sku, userId);
            }
        }
        this.insertAdminLog(product.getId(), AdminLog.Action.EDIT, userId);
    }

    private void updateProductLogicValue(Product product, boolean isInsert) {
        Double cashAmt = 0.0;
        Double cent = 0.0;
        Double mergeCashAmt = 0.0;
        Double mergeCent = 0.0;
        for (int i = 0; i < product.getSkus().size(); ++i) {
            Sku sku = product.getSkus().get(i);
            sku.setProduct(product);
            if (sku.getCashAmt() == null) {
                sku.setCashAmt(0.0);
            }
            if (sku.getCent() == null) {
                sku.setCent(0);
            }
            if (sku.getMergeCashAmt() == null) {
                sku.setMergeCashAmt(0.0);
            }
            if (sku.getMergeCent() == null) {
                sku.setMergeCent(0.0);
            }
            if (sku.getCashAmt() > 0.0) {
                cashAmt = Math.min(cashAmt, sku.getCashAmt());
            }
            if (sku.getCent() > 0) {
                cent = Math.min(cent, (double)sku.getCent().intValue());
            }
            if (sku.getMergeCashAmt() > 0.0) {
                mergeCashAmt = Math.min(mergeCashAmt, sku.getMergeCashAmt());
            }
            if (sku.getMergeCent() > 0.0) {
                mergeCent = Math.min(mergeCent, sku.getMergeCent());
            }
            if (!isInsert) continue;
            sku.setDisplayInlist(true);
        }
        if (isInsert) {
            product.setDisplayInlist(true);
        }
        product.setCashAmt(cashAmt);
        product.setCent(cent);
        product.setMergeCashAmt(mergeCashAmt);
        product.setMergeCent(mergeCent);
    }

    private void insertAdminLog(Long id, AdminLog.Action action, Long userId) {
        this.adminLogService.insert(new AdminLog(userId, AdminLog.ObjectType.PRODUCT, id, action));
    }

    @Override
    public List<Long> scheduleList() {
        try {
            Date date = new Date();
            List<Long> productIds = ((ProductDao)this.entityDao).findScheduleReadyListProductIds(date);
            if (CollectionUtils.isNotEmpty(productIds)) {
                ((ProductDao)this.entityDao).updateProductStatus(Product.Status.LIST, productIds);
                this.removeCached(productIds);
            }
            return productIds;
        }
        catch (Exception e) {
            this.logger.error("\u4ea7\u54c1\u4e0a\u67b6\u5931\u8d25.error:{}", (Throwable)e);
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public List<Long> scheduleDelist() {
        try {
            Date date = new Date();
            List<Long> productIds = ((ProductDao)this.entityDao).findScheduleDeListProductIds(date);
            if (CollectionUtils.isNotEmpty(productIds)) {
                ((ProductDao)this.entityDao).updateProductStatus(Product.Status.DELIST, productIds);
                this.removeCached(productIds);
            }
            return productIds;
        }
        catch (Exception e) {
            this.logger.error("\u4ea7\u54c1\u4e0b\u67b6\u5931\u8d25.error:{}", (Throwable)e);
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private void removeCached(List<Long> ids) {
        for (Long id : ids) {
            this.jedisTemplate.del("cache.product." + id);
        }
    }

    public boolean canChangeStatus(Product.Status from, Product.Status to) {
        if (from == Product.Status.DRAFT) {
            return to == Product.Status.DISCARD || to == Product.Status.AUDIT;
        }
        if (from == Product.Status.DISCARD) {
            return false;
        }
        if (from == Product.Status.AUDIT) {
            return to == Product.Status.REFUSE || to == Product.Status.READY_LIST || to == Product.Status.DRAFT;
        }
        if (from == Product.Status.REFUSE) {
            return to == Product.Status.DISCARD || to == Product.Status.DRAFT;
        }
        if (from == Product.Status.LIST) {
            return to == Product.Status.DELIST;
        }
        if (from == Product.Status.READY_LIST) {
            return to == Product.Status.DRAFT || to == Product.Status.LIST;
        }
        if (from == Product.Status.DELIST) {
            return to == Product.Status.LIST || to == Product.Status.DRAFT;
        }
        return false;
    }

    private void changeStatus(long id, Product.Status newStatus) {
        Product product = (Product)this.getProxy().getById(id);
        if (!this.canChangeStatus(product.getStatus(), newStatus)) {
            throw new ServiceException("\u5546\u54c1\u72b6\u6001\u4e0d\u80fd\u4ece " + product.getStatus().getLabel() + " \u6539\u4e3a " + newStatus.getLabel());
        }
        Product upProduct = new Product();
        upProduct.setId(id);
        upProduct.setStatus(newStatus);
        super.update(upProduct);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void discard(long id, Long userId) {
        this.insertAdminLog(id, AdminLog.Action.DISCARD, userId);
        this.changeStatus(id, Product.Status.DISCARD);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void submitAudit(Long id, Long userId) {
        this.insertAdminLog(id, AdminLog.Action.SUBMIT_AUDIT, userId);
        this.changeStatus(id, Product.Status.AUDIT);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void auditRefuse(Long id, Long userId) {
        this.insertAdminLog(id, AdminLog.Action.AUDIT_REFUSE, userId);
        this.changeStatus(id, Product.Status.REFUSE);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void auditOk(Long id, Long userId) {
        this.insertAdminLog(id, AdminLog.Action.AUDIT_OK, userId);
        this.changeStatus(id, Product.Status.READY_LIST);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void list(Long id, Long userId) throws Exception {
        Product product = (Product)this.getProxy().getById(id);
        if (!this.canChangeStatus(product.getStatus(), Product.Status.LIST)) {
            throw new ServiceException("\u5546\u54c1\u72b6\u6001\u4e0d\u80fd\u4ece " + product.getStatus().getLabel() + " \u6539\u4e3a " + Product.Status.LIST.getLabel());
        }
        Date now = new Date();
        if (product.getDelistTime() != null && product.getDelistTime().getTime() < now.getTime()) {
            throw new ServiceException("\u5546\u54c1\u4e0b\u67b6\u65f6\u95f4\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u5546\u54c1\u4e0b\u67b6\u65f6\u95f4\uff01");
        }
        Product productUpdate = new Product(id);
        productUpdate.setStatus(Product.Status.LIST);
        super.update(productUpdate);
        this.insertAdminLog(id, AdminLog.Action.LIST, userId);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void delist(Long id, Long userId) {
        Product product = (Product)this.getProxy().getById(id);
        if (!this.canChangeStatus(product.getStatus(), Product.Status.DELIST)) {
            throw new ServiceException("\u5546\u54c1\u72b6\u6001\u4e0d\u80fd\u4ece " + product.getStatus().getLabel() + " \u6539\u4e3a " + Product.Status.LIST.getLabel());
        }
        Product productUpdate = new Product(id);
        productUpdate.setStatus(Product.Status.DELIST);
        super.update(productUpdate);
        this.insertAdminLog(id, AdminLog.Action.DELIST, userId);
    }

    public long countListedProductBySupplierId(long supplierId) {
        return ((ProductDao)this.entityDao).countListedProductBySupplierId(supplierId);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Page<Product> search(Map<String, Object> params, Pageable pageable) {
        Long total = ((ProductDao)this.entityDao).searchTotal(params);
        if (total > (long)pageable.getOffset()) {
            params.put("offset", pageable.getOffset());
            params.put("pageSize", pageable.getPageSize());
            params.put("sort", pageable.getSort());
        }
        return null;
    }

    private ProductService getProxy() {
        return (ProductService)AopContext.currentProxy();
    }

    @Override
    public Long createTemp(String jsonStr, Long userId) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            throw new ServiceException("\u5546\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (userId == null) {
            throw new ServiceException("\u7528\u6237\u6ca1\u6709\u767b\u5f55");
        }
        ProdTemp temp = new ProdTemp();
        User user = new User();
        user.setId(userId);
        temp.setUser(user);
        temp.setJsonString(jsonStr);
        this.prodTempDao.insert(temp);
        return temp.getId();
    }

    @Override
    public void updateTemp(String jsonStr, Long id) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            throw new ServiceException("\u5546\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ProdTemp temp = new ProdTemp();
        temp.setId(id);
        temp.setJsonString(jsonStr);
        this.prodTempDao.update(temp);
    }

    @Override
    public ProdTemp getLastProdTempByUserId(Long userId) {
        return this.prodTempDao.getByUserId(userId);
    }

    @Override
    public void updateIsInListStatus(Long productId) {
        ((ProductDao)this.entityDao).updateIsInListStatus(productId);
    }
}

