/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.ProdSKUMeta;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.SkuMeta;
import com.rocoinfo.rocomall.repository.SkuMetaDao;
import com.rocoinfo.rocomall.repository.dict.DictSkuMetaDao;
import com.rocoinfo.rocomall.service.product.ISkuMetaService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SkuMetaService
extends CrudService<SkuMetaDao, SkuMeta>
implements ISkuMetaService {
    @Autowired
    private DictSkuMetaDao dictSkuMetaDao;

    @Override
    public SkuMeta getByProductId(Long productId) {
        return ((SkuMetaDao)this.entityDao).getByProductId(productId);
    }

    @Override
    public SkuMeta getByProductIdAndDictMeta(Long productId) {
        SkuMeta meta = ((SkuMetaDao)this.entityDao).getByProductId(productId);
        if (meta == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)meta.getAttribute1Name())) {
            meta.setDictSkuMeta1(this.dictSkuMetaDao.selectByName(meta.getAttribute1Name()));
        }
        if (StringUtils.isNotBlank((CharSequence)meta.getAttribute2Name())) {
            meta.setDictSkuMeta2(this.dictSkuMetaDao.selectByName(meta.getAttribute2Name()));
        }
        if (StringUtils.isNotBlank((CharSequence)meta.getAttribute3Name())) {
            meta.setDictSkuMeta3(this.dictSkuMetaDao.selectByName(meta.getAttribute3Name()));
        }
        return meta;
    }

    @Override
    public ProdSKUMeta getProdSkuMetas(Sku sku) {
        List<Map<String, String>> skuMetaValueList;
        ProdSKUMeta skuMeta = new ProdSKUMeta();
        if (sku != null && !CollectionUtils.isEmpty(skuMetaValueList = ((SkuMetaDao)this.entityDao).getProdSkuMetas(sku.getProduct().getId()))) {
            String sku1Name = null;
            String sku2Name = null;
            String sku3Name = null;
            ArrayList sku1ValueList = Lists.newArrayList();
            ArrayList sku2ValueList = Lists.newArrayList();
            ArrayList sku3ValueList = Lists.newArrayList();
            String selectedSkuValue1 = StringUtils.trimToEmpty((String)sku.getAttribute1());
            String selectedSkuValue2 = StringUtils.trimToEmpty((String)sku.getAttribute2());
            int len = skuMetaValueList.size();
            for (int i = 0; i < len; ++i) {
                Map<String, String> rowItem = skuMetaValueList.get(i);
                if (i == 0) {
                    sku1Name = StringUtils.trimToEmpty((String)rowItem.get("attribute1_name"));
                    sku2Name = StringUtils.trimToEmpty((String)rowItem.get("attribute2_name"));
                    sku3Name = StringUtils.trimToEmpty((String)rowItem.get("attribute3_name"));
                }
                String skuValue1 = StringUtils.trimToEmpty((String)rowItem.get("attribute1"));
                String skuValue2 = StringUtils.trimToEmpty((String)rowItem.get("attribute2"));
                String skuValue3 = StringUtils.trimToEmpty((String)rowItem.get("attribute3"));
                if (!skuValue1.isEmpty() && !sku1ValueList.contains(skuValue1)) {
                    sku1ValueList.add(skuValue1);
                }
                if (!skuValue2.isEmpty() && skuValue1.equals(selectedSkuValue1) && !sku2ValueList.contains(skuValue2)) {
                    sku2ValueList.add(skuValue2);
                }
                if (skuValue3.isEmpty() || !skuValue1.equals(selectedSkuValue1) || !skuValue2.equals(selectedSkuValue2) || sku3ValueList.contains(skuValue3)) continue;
                sku3ValueList.add(skuValue3);
            }
            if (StringUtils.isNotEmpty(sku1Name)) {
                skuMeta.setSku1(new ProdSKUMeta.MetaItem(sku1Name, sku1ValueList));
            }
            if (StringUtils.isNotEmpty(sku2Name)) {
                skuMeta.setSku2(new ProdSKUMeta.MetaItem(sku2Name, sku2ValueList));
            }
            if (StringUtils.isNotEmpty(sku3Name)) {
                skuMeta.setSku3(new ProdSKUMeta.MetaItem(sku3Name, sku3ValueList));
            }
        }
        return skuMeta;
    }
}

