/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.wx;

import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.wx.Menu;
import com.rocoinfo.rocomall.entity.wx.WXUser;
import com.rocoinfo.rocomall.entity.wx.WxMenu;
import com.rocoinfo.rocomall.enumconst.Gender;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.service.impl.wx.WxMenuService;
import com.rocoinfo.rocomall.service.wx.IWxApiService;
import com.rocoinfo.rocomall.utils.HttpUtils;
import com.rocoinfo.rocomall.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.NameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WxApiService
implements IWxApiService {
    private static final int EXPIRE_SECORD = 6600;
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private WxMenuService menuService;

    @Override
    public String getAccessToken(String appId, String appSecret) {
        String cachedToken = this.jedisTemplate.get("wxAccessToken");
        if (StringUtils.isNotEmpty((CharSequence)cachedToken)) {
            return cachedToken;
        }
        String accessToken = "";
        String getAccessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
        String respJson = HttpUtils.get(getAccessTokenUrl = String.format(getAccessTokenUrl, appId, appSecret), new NameValuePair[0]);
        Map map = JsonUtils.fromJson(respJson, Map.class);
        if (map != null && StringUtils.isNotEmpty((CharSequence)(accessToken = StringUtils.trimToEmpty((String)((String)map.get("access_token")))))) {
            this.jedisTemplate.setex("wxAccessToken", accessToken, 6600);
        }
        return accessToken;
    }

    @Override
    public StatusDto<String> createWeixinMenu(String appId, String appSecret) {
        List<Menu> topMenuList = this.menuService.findTopWithSubMenus();
        if (CollectionUtils.isNotEmpty(topMenuList)) {
            ArrayList<WxMenu> createMenuList = new ArrayList<WxMenu>(topMenuList.size());
            for (Menu topMenu : topMenuList) {
                WxMenu createdWxMenu = WxMenu.valueOf(topMenu);
                List<Menu> subMenuList = topMenu.getChildMenuList();
                if (subMenuList != null && !subMenuList.isEmpty()) {
                    for (Menu sub : subMenuList) {
                        createdWxMenu.addSubMenu(WxMenu.valueOf(sub));
                    }
                }
                createMenuList.add(createdWxMenu);
            }
            String postUrl = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=%s";
            postUrl = String.format(postUrl, this.getAccessToken(appId, appSecret));
            HashMap<String, ArrayList<WxMenu>> map = new HashMap<String, ArrayList<WxMenu>>();
            map.put("button", createMenuList);
            String reqJson = JsonUtils.pojoToJson(map);
            String respJson = HttpUtils.postJson(postUrl, reqJson);
            Map resultMap = JsonUtils.fromJson(respJson, Map.class);
            if (resultMap != null) {
                StatusDto<String> respMsg = new StatusDto<String>();
                String resultCode = String.valueOf(resultMap.get("errcode"));
                if ("0".equals(resultCode)) {
                    respMsg.setCode("1");
                } else {
                    respMsg.setCode(resultCode);
                }
                respMsg.setMessage((String)resultMap.get("errmsg"));
                return respMsg;
            }
            return StatusDto.buildFailureStatusDto("\u521b\u5efa\u5fae\u4fe1\u83dc\u5355 \u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff01");
        }
        return StatusDto.buildSuccessStatusDto("\u540e\u53f0\u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u83dc\u5355\uff0c\u4e0d\u80fd\u521b\u5efa");
    }

    @Override
    public WXUser getWxUserInfo(String appId, String appSecret, String openId) {
        WXUser wxUser = null;
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            String getUserInfoUrl = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s";
            String respJson = HttpUtils.get(getUserInfoUrl = String.format(getUserInfoUrl, this.getAccessToken(appId, appSecret), openId), new NameValuePair[0]);
            Map map = JsonUtils.fromJson(respJson, Map.class);
            if (map != null && NumberUtils.toInt((String)String.valueOf(map.get("subscribe"))) == 1) {
                wxUser = new WXUser();
                wxUser.setNickName((String)map.get("nickname"));
                Integer sex = (Integer)map.get("sex");
                wxUser.setSex(sex == 1 ? Gender.male : (sex == 2 ? Gender.female : Gender.unknown));
                wxUser.setCountry((String)map.get("country"));
                wxUser.setProvince((String)map.get("province"));
                wxUser.setCity((String)map.get("city"));
                wxUser.setHeadImgUrl((String)map.get("headimgurl"));
            }
        }
        return wxUser;
    }

    @Override
    public void downloadMediaFile(String mediaId, String saveRealDir) {
    }

    @Override
    public String getJsApiTicket(String appId, String appSecret) {
        String cachedJsApiTicket = this.jedisTemplate.get("wxjsApiTicketKey");
        if (StringUtils.isNotEmpty((CharSequence)cachedJsApiTicket)) {
            return cachedJsApiTicket;
        }
        String jsApiTicket = "";
        String jsApiTicketUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";
        String respJson = HttpUtils.get(jsApiTicketUrl = String.format(jsApiTicketUrl, this.getAccessToken(appId, appSecret)), new NameValuePair[0]);
        Map map = JsonUtils.fromJson(respJson, Map.class);
        if (map != null && StringUtils.isNotEmpty((CharSequence)(jsApiTicket = StringUtils.trimToEmpty((String)((String)map.get("ticket")))))) {
            this.jedisTemplate.setex("wxjsApiTicketKey", jsApiTicket, 6600);
        }
        return jsApiTicket;
    }
}

