/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.wx;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.wx.MsgEntity;
import com.rocoinfo.rocomall.entity.wx.WXItem;
import com.rocoinfo.rocomall.entity.wx.WXMsg;
import com.rocoinfo.rocomall.entity.wx.WXMusic;
import com.rocoinfo.rocomall.entity.wx.WXUser;
import com.rocoinfo.rocomall.entity.wx.WxMessage;
import com.rocoinfo.rocomall.enumconst.WXMsgType;
import com.rocoinfo.rocomall.enumconst.WxEvent;
import com.rocoinfo.rocomall.repository.wx.WxMsgDao;
import com.rocoinfo.rocomall.service.impl.wx.WxApiService;
import com.rocoinfo.rocomall.service.impl.wx.WxUserService;
import com.rocoinfo.rocomall.service.wx.IWxMsgService;
import com.rocoinfo.rocomall.utils.VelocityUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WxMsgService
extends CrudService<WxMsgDao, WXMsg>
implements IWxMsgService {
    @Autowired
    private WxUserService wxUserService;
    @Autowired
    private WxApiService wxAipService;

    @Override
    public WXMsg searchEventMsgReply(String appId, String appSecret, WXMsg inMsg) {
        WXMsg replyMsg = null;
        if (inMsg != null) {
            String openId = inMsg.getFromUserName();
            HashMap<String, Object> velocityCtxDataMap = new HashMap<String, Object>();
            velocityCtxDataMap.put("openId", openId);
            if (inMsg.getEvent().equals(WxEvent.SUBSCRIBE.getEventType())) {
                WXUser user = this.wxUserService.getWXUserByOpenId(openId);
                if (user == null) {
                    user = new WXUser();
                    user.setOpenId(openId);
                    this.pullWxUserInfo(appId, appSecret, user);
                } else {
                    user.setUnsubscribeTime(null);
                    if (StringUtils.isEmpty((CharSequence)user.getNickName())) {
                        this.pullWxUserInfo(appId, appSecret, user);
                    }
                }
                if (this.wxUserService.isWxUserBounded(openId)) {
                    user.setBoundTime(new Date());
                }
                user.setSubscribeTime(new Date());
                if (user.getId() == null) {
                    this.wxUserService.insert(user);
                } else {
                    this.wxUserService.update(user);
                }
                WxMessage wxMsg = ((WxMsgDao)this.entityDao).searchEventMsg(inMsg.getEvent());
                if (wxMsg != null) {
                    replyMsg = this.convertToWXMsg(inMsg, wxMsg.getMsgContents(), velocityCtxDataMap);
                }
            } else if (inMsg.getEvent().equals(WxEvent.UNSUBSCRIBE.getEventType())) {
                WXUser user = this.wxUserService.getWXUserByOpenId(openId);
                if (user != null) {
                    user.setSubscribeTime(null);
                    user.setBoundTime(null);
                    user.setUnsubscribeTime(new Date());
                    this.wxUserService.update(user);
                    WxMessage wxMsg = ((WxMsgDao)this.entityDao).searchEventMsg(inMsg.getEvent());
                    if (wxMsg != null) {
                        replyMsg = this.convertToWXMsg(inMsg, wxMsg.getMsgContents(), velocityCtxDataMap);
                    }
                }
            } else if (inMsg.getEvent().equals(WxEvent.CLICK.getEventType())) {
                String key = inMsg.getEventKey();
                boolean boundAccess = Boolean.valueOf(StringUtils.substringAfter((String)key, (String)"_"));
            }
        }
        return replyMsg;
    }

    @Override
    public WXMsg searchTextMsgReply(String appId, String appSecret, WXMsg inMsg) {
        return null;
    }

    private void pullWxUserInfo(String appId, String appSecret, WXUser wxUser) {
        WXUser userInfo = this.wxAipService.getWxUserInfo(appId, appSecret, wxUser.getOpenId());
        if (userInfo != null) {
            wxUser.setNickName(userInfo.getNickName());
            wxUser.setSex(userInfo.getSex());
            wxUser.setCountry(userInfo.getCountry());
            wxUser.setProvince(userInfo.getProvince());
            wxUser.setCity(userInfo.getCity());
            wxUser.setHeadImgUrl(userInfo.getHeadImgUrl());
        }
    }

    private WXMsg convertToWXMsg(WXMsg inMsg, List<MsgEntity> autoReplyMsg, Map<String, Object> viewParam) {
        if (autoReplyMsg == null || autoReplyMsg.isEmpty()) {
            return null;
        }
        WXMsg wxMsg = new WXMsg();
        wxMsg.setToUserName(inMsg.getFromUserName());
        wxMsg.setFromUserName(inMsg.getToUserName());
        wxMsg.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        int index = 1;
        ArrayList<WXItem> articles = new ArrayList<WXItem>();
        String siteBasePath = PropertyHolder.getBaseurl();
        for (MsgEntity msgEntity : autoReplyMsg) {
            WXItem item;
            WXMsgType msgTypeEnum = msgEntity.getMsgType();
            wxMsg.setMsgType(msgTypeEnum.toString());
            if (index == 1) {
                if (WXMsgType.text.equals((Object)msgTypeEnum)) {
                    String content = VelocityUtils.renderTemplateContent(msgEntity.getContent(), viewParam);
                    wxMsg.setContent(content);
                } else if (msgTypeEnum.equals((Object)WXMsgType.news)) {
                    item = new WXItem();
                    item.setTitle(VelocityUtils.renderTemplateContent(msgEntity.getTitle(), viewParam));
                    if (StringUtils.isNotBlank((CharSequence)msgEntity.getDescription())) {
                        item.setDescription(VelocityUtils.renderTemplateContent(msgEntity.getDescription(), viewParam));
                    } else {
                        item.setDescription(VelocityUtils.renderTemplateContent(msgEntity.getContent(), viewParam));
                    }
                    if (StringUtils.isNotBlank((CharSequence)msgEntity.getPicUrl())) {
                        if (msgEntity.getPicUrl().indexOf("http://") > -1) {
                            item.setPicurl(msgEntity.getPicUrl());
                        } else {
                            item.setPicurl(siteBasePath + msgEntity.getPicUrl());
                        }
                    }
                    item.setUrl(VelocityUtils.renderTemplateContent(msgEntity.getUrl(), viewParam));
                    articles.add(item);
                } else if (msgTypeEnum.equals((Object)WXMsgType.music)) {
                    WXMusic music = new WXMusic();
                    music.setTitle(msgEntity.getTitle());
                    music.setDescription(msgEntity.getDescription());
                    String musciUrl = "";
                    if (StringUtils.isNotBlank((CharSequence)msgEntity.getMusicURL())) {
                        musciUrl = msgEntity.getMusicURL().indexOf("http://") > -1 ? msgEntity.getMusicURL() : siteBasePath + msgEntity.getMusicURL();
                    }
                    music.setMusicUrl(musciUrl);
                    music.sethQMusicUrl(musciUrl);
                    wxMsg.setMusic(music);
                }
            } else {
                item = new WXItem();
                item.setTitle(VelocityUtils.renderTemplateContent(msgEntity.getTitle(), viewParam));
                item.setDescription(VelocityUtils.renderTemplateContent(msgEntity.getContent(), viewParam));
                if (StringUtils.isNotBlank((CharSequence)msgEntity.getPicUrl())) {
                    if (msgEntity.getPicUrl().indexOf("http://") > -1) {
                        item.setPicurl(msgEntity.getPicUrl());
                    } else {
                        item.setPicurl(siteBasePath + msgEntity.getPicUrl());
                    }
                }
                item.setUrl(VelocityUtils.renderTemplateContent(msgEntity.getUrl(), viewParam));
                articles.add(item);
            }
            ++index;
        }
        if (!articles.isEmpty()) {
            wxMsg.setArticles(articles);
            wxMsg.setArticleCount(articles.size());
        }
        return wxMsg;
    }
}

