/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.wx;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.wx.WxRedPackRecord;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.wx.WxRedPackRecordDao;
import com.rocoinfo.rocomall.service.wx.IWxRedPackRecordService;
import java.util.ArrayList;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WxRedPackRecordService
extends CrudService<WxRedPackRecordDao, WxRedPackRecord>
implements IWxRedPackRecordService {
    private Logger log = LoggerFactory.getLogger(WxRedPackRecordService.class);
    @Autowired
    private JedisTemplate jedisTemplate;

    @Override
    public WxRedPackRecord getByOpenId(String openId) {
        return ((WxRedPackRecordDao)this.entityDao).getByOpenId(openId);
    }

    @Override
    public int getCount(WxRedPackRecord.Type type, WxRedPackRecord.Status status) {
        return ((WxRedPackRecordDao)this.entityDao).getCount(type, status);
    }

    @Override
    public void updateRecordById(Long id, WxRedPackRecord.Status status, String wxsendListid) {
        ((WxRedPackRecordDao)this.entityDao).updateRecordById(id, status, wxsendListid);
    }

    @Override
    public void initRedPackPool(int[][] meta) {
        if (this.getCount(WxRedPackRecord.Type.INSUR_CALCULATE, WxRedPackRecord.Status.SUCCESS) > 0) {
            this.log.info("\u7ea2\u5305\u6c60\u5b50\u4e0d\u80fd\u91cd\u65b0\u751f\u6210!");
            return;
        }
        ArrayList<String> pool = new ArrayList<String>();
        for (int[] arr : meta) {
            for (int i = 0; i < arr[1]; ++i) {
                pool.add(String.valueOf(arr[0]));
            }
        }
        Random random = new Random();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < pool.size(); ++j) {
                int index1 = random.nextInt(pool.size() - 1);
                String temp = (String)pool.get(index1);
                pool.set(index1, (String)pool.get(j));
                pool.set(j, temp);
            }
        }
        String[] result = pool.toArray(new String[pool.size()]);
        this.jedisTemplate.lpush(Constants.RED_PACK_POOL, result);
    }
}

