/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.PropertyHolder;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.springframework.util.StringUtils;

public final class EmailSender {
    private static final int PORT = 25;
    private static Session session = null;

    public static void send(String receiver, String subject, String mailContent, String mimetype) {
        EmailSender.send(new String[]{receiver}, subject, mailContent, mimetype);
    }

    public static void send(String[] receivers, String subject, String mailContent, String mimetype) {
        EmailSender.send(receivers, subject, mailContent, null, mimetype);
    }

    public static void send(String[] receivers, String subject, String mailContent, File[] attachements, String mimetype) {
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            String senderEmail = PropertyHolder.getEmailSender();
            String from = MimeUtility.encodeText((String)"\u8d22\u8ff7\u6d3e\u79ef\u5206\u5546\u57ce") + "<%s>";
            from = String.format(from, senderEmail);
            mimeMessage.setFrom((Address)new InternetAddress(from));
            InternetAddress[] toAddress = new InternetAddress[receivers.length];
            for (int i = 0; i < receivers.length; ++i) {
                toAddress[i] = new InternetAddress(receivers[i]);
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])toAddress);
            mimeMessage.setSubject(subject);
            mimeMessage.setReplyTo(new Address[]{new InternetAddress(senderEmail)});
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)mailContent, (!StringUtils.isEmpty((Object)mimetype) ? mimetype : "text/plain") + ";charset=" + "UTF-8");
            multipart.addBodyPart((BodyPart)body);
            if (attachements != null) {
                for (File attachement : attachements) {
                    MimeBodyPart attache = new MimeBodyPart();
                    attache.setDataHandler(new DataHandler((DataSource)new FileDataSource(attachement)));
                    String fileName = StringUtils.getFilename((String)attachement.getName());
                    attache.setFileName(MimeUtility.encodeText((String)fileName, (String)"UTF-8", null));
                    multipart.addBodyPart((BodyPart)attache);
                }
            }
            mimeMessage.setContent((Multipart)multipart);
            mimeMessage.setSentDate(new Date());
            Transport transport = session.getTransport();
            transport.connect(PropertyHolder.getEmailServer(), 25, PropertyHolder.getEmailSender(), PropertyHolder.getEmailSenderPwd());
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            transport.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff01");
        }
    }

    static {
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", "smtp");
        session = Session.getInstance((Properties)props);
    }
}

