/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.common.service.ExcelFormatException;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.utils.ExcelHeader;
import com.rocoinfo.rocomall.utils.ExcelMergeRegion;
import com.rocoinfo.rocomall.utils.ExcelTemplate;
import com.rocoinfo.rocomall.utils.ExcelTitle;
import com.rocoinfo.rocomall.utils.ReflectionUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExcelUtil {
    private static ExcelUtil util = new ExcelUtil();

    private ExcelUtil() {
    }

    public static ExcelUtil getInstance() {
        return util;
    }

    private <E> ExcelTemplate handleObj2Excel(String excelTemplateFile, List<E> exportDataList, Class<E> clz, boolean isClassPath) {
        ExcelTemplate template = new ExcelTemplate();
        if (isClassPath) {
            template.readTemplateByClasspath(excelTemplateFile);
        } else {
            template.readTemplateByPath(excelTemplateFile);
        }
        List<ExcelHeader> headers = this.getHeaderList(clz);
        template.createNewRow();
        for (ExcelHeader eh : headers) {
            template.createCell(eh.getTitle());
        }
        for (ExcelHeader rowData : exportDataList) {
            template.createNewRow();
            for (ExcelHeader eh : headers) {
                this.createCellAndWriteValue(template, rowData, eh);
            }
        }
        return template;
    }

    private <E> void createCellAndWriteValue(ExcelTemplate template, E rowData, ExcelHeader excelHeader) {
        Object propValue = ReflectionUtils.getFieldValue(rowData, excelHeader.getPropertyName());
        if (propValue == null) {
            propValue = "";
        }
        if (propValue instanceof Date) {
            template.createCell((Date)propValue);
        } else if (propValue instanceof Double) {
            template.createCell((Double)propValue);
        } else if (propValue instanceof Integer) {
            template.createCell((Integer)propValue);
        } else if (propValue instanceof Boolean) {
            template.createCell((Boolean)propValue);
        } else {
            template.createCell(propValue.toString());
        }
    }

    public <E> void exportObj2ExcelByTemplate(Map<String, String> variableExtras, String excelTemplatePath, OutputStream os, List<E> exportDataList, Class<E> clz, boolean isClasspath) {
        ExcelTemplate et = this.handleObj2Excel(excelTemplatePath, exportDataList, clz, isClasspath);
        et.replaceFinalData(variableExtras);
        et.wirteToStream(os);
    }

    public <E> void exportObj2ExcelByTemplate(Map<String, String> variableExtras, String excelTemplatePath, String outPath, List<E> exportDataList, Class<E> clz, boolean isClasspath) {
        ExcelTemplate et = this.handleObj2Excel(excelTemplatePath, exportDataList, clz, isClasspath);
        et.replaceFinalData(variableExtras);
        et.writeToFile(outPath);
    }

    public <E> void exportObj2ExcelByTemplate(Properties variableExtras, String excelTemplatePath, OutputStream os, List<E> exportDataList, Class<E> clz, boolean isClasspath) {
        ExcelTemplate et = this.handleObj2Excel(excelTemplatePath, exportDataList, clz, isClasspath);
        et.replaceFinalData(variableExtras);
        et.wirteToStream(os);
    }

    public <E> void exportObj2ExcelByTemplate(Properties variableExtras, String excelTemplatePath, String outFile, List<E> exportDataList, Class<E> clz, boolean isClasspath) {
        ExcelTemplate et = this.handleObj2Excel(excelTemplatePath, exportDataList, clz, isClasspath);
        et.replaceFinalData(variableExtras);
        et.writeToFile(outFile);
    }

    private <E> Workbook handleObj2Excel(List<E> exportDataList, Class<E> clz, boolean isXssf, ExcelMergeRegion ... mergeCells) {
        Object wb = null;
        wb = isXssf ? new XSSFWorkbook() : new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        Row row = sheet.createRow(0);
        List<ExcelHeader> headers = this.getHeaderList(clz);
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue(headers.get(i).getTitle());
        }
        Object obj = null;
        for (int rowIdx = 0; rowIdx < exportDataList.size(); ++rowIdx) {
            row = sheet.createRow(rowIdx + 1);
            obj = exportDataList.get(rowIdx);
            for (int colIdx = 0; colIdx < headers.size(); ++colIdx) {
                Cell cell = row.createCell(colIdx);
                CellStyle style = wb.createCellStyle();
                style.setAlignment((short)2);
                style.setVerticalAlignment((short)1);
                style.setBorderTop((short)1);
                style.setBorderLeft((short)1);
                cell.setCellStyle(style);
                Object propValue = ReflectionUtils.getFieldValue(obj, headers.get(colIdx).getPropertyName());
                if (propValue == null) {
                    propValue = "";
                }
                if (propValue instanceof Date) {
                    cell.setCellValue((Date)propValue);
                    continue;
                }
                if (propValue instanceof Double) {
                    cell.setCellValue(((Double)propValue).doubleValue());
                    continue;
                }
                if (propValue instanceof Integer) {
                    cell.setCellValue((double)((Integer)propValue).intValue());
                    continue;
                }
                if (propValue instanceof Boolean) {
                    cell.setCellValue(((Boolean)propValue).booleanValue());
                    continue;
                }
                cell.setCellValue(propValue.toString());
            }
        }
        if (exportDataList.size() > 0 && ArrayUtils.isNotEmpty((Object[])mergeCells)) {
            for (ExcelMergeRegion range : mergeCells) {
                sheet.addMergedRegion(new CellRangeAddress(range.getFirstRow(), range.getLastRow(), range.getFirstCol(), range.getLastCol()));
            }
        }
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> void exportObj2Excel(String outFileAbsolutePath, List<E> exportDataList, Class<E> clz, boolean isXssf, ExcelMergeRegion ... mergeCells) {
        Workbook wb = this.handleObj2Excel(exportDataList, clz, isXssf, mergeCells);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFileAbsolutePath);
            wb.write((OutputStream)fos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public <E> void exportObj2Excel(OutputStream os, List<E> exportDataList, Class<E> clz, boolean isXssf, ExcelMergeRegion ... mergeCells) {
        try {
            Workbook wb = this.handleObj2Excel(exportDataList, clz, isXssf, mergeCells);
            wb.write(os);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <E> List<E> readExcel2ObjsByClasspath(String clsPath, Class<E> clz, int titleRowIndex) {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)this.getClass().getResourceAsStream(clsPath));
            return this.handleExcel2Objs(wb, clz, titleRowIndex);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <E> List<E> readExcel2ObjsByStream(InputStream inputStream, Class<E> clz) {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)inputStream);
            return this.handleExcel2Objs(wb, clz, 0);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public <E> List<E> readExcel2ObjsByFile(File file, Class<E> clz) {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((File)file);
            return this.handleExcel2Objs(wb, clz, 0);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public <E> List<E> readExcel2ObjsByPath(String path, Class<E> clz, int titleRowIndex) {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((File)new File(path));
            return this.handleExcel2Objs(wb, clz, titleRowIndex);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <E> List<E> readExcel2ObjsByClasspath(String clsPath, Class<E> clz) {
        return this.readExcel2ObjsByClasspath(clsPath, clz, 0);
    }

    public <E> List<E> readExcel2ObjsByPath(String path, Class<E> clz) {
        return this.readExcel2ObjsByPath(path, clz, 0);
    }

    private Object getCellValue(Cell cell) {
        Object cellValue = null;
        switch (cell.getCellType()) {
            case 3: {
                cellValue = "";
                break;
            }
            case 4: {
                cellValue = cell.getBooleanCellValue();
                break;
            }
            case 2: {
                cellValue = cell.getCellFormula();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = cell.getDateCellValue();
                    break;
                }
                cellValue = new DecimalFormat("#").format(cell.getNumericCellValue());
                break;
            }
            case 1: {
                cellValue = cell.getStringCellValue();
                break;
            }
            default: {
                cellValue = null;
            }
        }
        return cellValue;
    }

    private <E> List<E> handleExcel2Objs(Workbook wb, Class<E> clz, int titleRowIndex) {
        Sheet sheet = wb.getSheetAt(0);
        if (sheet.getLastRowNum() < 1) {
            throw new RuntimeException("excel\u8868\u683c\u6ca1\u6709\u4efb\u4f55\u6570\u636e!");
        }
        Row row = sheet.getRow(titleRowIndex);
        ArrayList<E> objs = new ArrayList<E>();
        Map<Integer, ExcelHeader> colIndexPropertyMap = this.getHeaderMap(row, clz);
        if (colIndexPropertyMap == null || colIndexPropertyMap.isEmpty()) {
            throw new RuntimeException("\u8981\u8bfb\u53d6\u7684Excel\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u68c0\u67e5\u662f\u5426\u8bbe\u5b9a\u4e86\u5408\u9002\u7684\u884c");
        }
        for (int dataRowIdx = titleRowIndex + 1; dataRowIdx <= sheet.getLastRowNum(); ++dataRowIdx) {
            row = sheet.getRow(dataRowIdx);
            E obj = this.getInstance(clz);
            for (int colIndx = 0; colIndx < row.getLastCellNum(); ++colIndx) {
                Cell cell = row.getCell(colIndx);
                ExcelHeader header = colIndexPropertyMap.get(colIndx);
                if (header == null) continue;
                String errorMsg = "\u7b2c%d\u884c,\u7b2c%d\u5217\u4e3a\u5fc5\u586b\u9879.";
                Object cellValue = this.getCellValue(cell);
                if (header.isRequired() && (cellValue == null || cellValue instanceof String && StringUtils.isBlank((CharSequence)((String)cellValue)))) {
                    String error = String.format(errorMsg, dataRowIdx + 1, colIndx + 1);
                    throw new ExcelFormatException(error);
                }
                if (cellValue == null) continue;
                try {
                    ReflectionUtils.setFieldValue(obj, header.getPropertyName(), cellValue);
                    continue;
                }
                catch (Exception e) {
                    StringBuffer sb = new StringBuffer("\u7b2c");
                    sb.append(dataRowIdx + 1).append("\u884c,\u7b2c").append(colIndx + 1).append("\u5217\u6570\u636e\u3010").append(cellValue).append("\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
                    if (StringUtils.isNotBlank((CharSequence)header.getDataFormat())) {
                        sb.append(",\u6b63\u786e\u683c\u5f0f\u3010").append(header.getDataFormat()).append("\u3011.");
                    }
                    throw new ExcelFormatException(sb.toString());
                }
            }
            objs.add(obj);
        }
        return objs;
    }

    private <E> E getInstance(Class<E> clz) {
        try {
            return clz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new ServiceException("\u521b\u5efa\u5bf9\u8c61\u5931\u8d25");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ServiceException("\u521b\u5efa\u5bf9\u8c61\u5931\u8d25");
        }
    }

    private <E> List<ExcelHeader> getHeaderList(Class<E> clz) {
        ArrayList<ExcelHeader> headers = new ArrayList<ExcelHeader>();
        try {
            PropertyDescriptor[] proertyDescritors;
            BeanInfo info = Introspector.getBeanInfo(clz);
            for (PropertyDescriptor pd : proertyDescritors = info.getPropertyDescriptors()) {
                String propertyName = pd.getName();
                Method method = pd.getReadMethod();
                if (!method.isAnnotationPresent(ExcelTitle.class)) continue;
                ExcelTitle excelTitle = method.getAnnotation(ExcelTitle.class);
                headers.add(new ExcelHeader(excelTitle.title(), excelTitle.order(), propertyName, excelTitle.required(), excelTitle.dataFormat()));
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        Collections.sort(headers);
        return headers;
    }

    private <E> Map<Integer, ExcelHeader> getHeaderMap(Row titleRow, Class<E> clz) {
        List<ExcelHeader> headers = this.getHeaderList(clz);
        HashMap<Integer, ExcelHeader> maps = new HashMap<Integer, ExcelHeader>();
        int cessCounts = 0;
        for (Cell cell : titleRow) {
            String title = cell.getStringCellValue();
            if (!this.makeLinks(headers, cell, maps)) {
                throw new ExcelFormatException("\u5217\u540d\u3010" + title + "\u3011\u65e0\u6cd5\u5339\u914d,\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f!");
            }
            ++cessCounts;
        }
        if (cessCounts != headers.size()) {
            throw new ExcelFormatException("\u7f3a\u5c11\u6570\u636e\u5217,\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f!");
        }
        return maps;
    }

    private boolean makeLinks(List<ExcelHeader> headers, Cell cell, Map<Integer, ExcelHeader> maps) {
        for (ExcelHeader eh : headers) {
            if (!eh.getTitle().equals(cell.getStringCellValue().trim())) continue;
            maps.put(cell.getColumnIndex(), eh);
            return true;
        }
        return false;
    }
}

