/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;

public final class RandomTools {
    private static final String RAND_CHARS = "0123456789abcdefghigklmnopqrstuvtxyzABCDEFGHIGKLMNOPQRSTUVWXYZ";
    private static final int[] prefix = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static Random random = new Random();

    public static int rand(int max) {
        return random.nextInt(max);
    }

    public static int rand(int min, int max) {
        if (min < max) {
            if (min > 0) {
                return RandomTools.rand(max - min) + min;
            }
            return RandomTools.rand(max);
        }
        return min;
    }

    public static String getRandStr(int length, int randType) {
        StringBuffer hash = new StringBuffer(length);
        if (randType == 1) {
            for (int i = 0; i < length; ++i) {
                hash.append(RAND_CHARS.charAt(10 + random.nextInt(52)));
            }
        } else if (randType == 2) {
            for (int i = 0; i < length; ++i) {
                hash.append(RAND_CHARS.charAt(random.nextInt(10)));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                hash.append(RAND_CHARS.charAt(random.nextInt(62)));
            }
        }
        return hash.toString();
    }

    public static String toFixdLengthString(int num, int fixdlenth) {
        StringBuffer sb = new StringBuffer();
        String strNum = String.valueOf(num);
        if (fixdlenth - strNum.length() < 0) {
            throw new RuntimeException("\u5c06\u6570\u5b57" + num + "\u8f6c\u5316\u4e3a\u957f\u5ea6\u4e3a" + fixdlenth + "\u7684\u5b57\u7b26\u4e32\u53d1\u751f\u5f02\u5e38\uff01");
        }
        sb.append(RandomTools.generateZeroString(fixdlenth - strNum.length()));
        sb.append(strNum);
        return sb.toString();
    }

    public static long randomLong(int digit) {
        if (digit >= 19 || digit <= 0) {
            throw new IllegalArgumentException("digit should between 1 and 18(1<=digit<=18)");
        }
        String s = RandomStringUtils.randomNumeric((int)(digit - 1));
        return Long.parseLong(RandomTools.getPrefix() + s);
    }

    public static long randomLong(int minDigit, int maxDigit) {
        if (minDigit > maxDigit) {
            throw new IllegalArgumentException("minDigit > maxDigit");
        }
        if (minDigit <= 0 || maxDigit >= 19) {
            throw new IllegalArgumentException("minDigit <=0 || maxDigit>=19");
        }
        return RandomTools.randomLong(minDigit + RandomTools.getDigit(maxDigit - minDigit));
    }

    private static int getDigit(int max) {
        return random.nextInt(max + 1);
    }

    private static String getPrefix() {
        return prefix[random.nextInt(prefix.length)] + "";
    }

    private static String generateZeroString(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }
}

