package com.rocoinfo.rocomall.entity;

import java.util.List;

import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;

/**
 * 客户收货地址
 * 
 * @author zhangmin
 */
public class Address extends IdEntity {

	private static final long serialVersionUID = -2682522000628596954L;

	private User user;

	/**
	 * 地址区域（包括省市县）
	 */
	private DictProviceCity provCity;

	/**
	 * 详细街道地址
	 */
	private String address;

	private String recipient;

	private String postcode;

	/**
	 * 收货人手机
	 */
	private String mobile;

	/**
	 * 收货人座机
	 */
	private String recipientPhone;

	/**
	 * 是否是用户的默认地址
	 */
	private Boolean defaultAddr = Boolean.FALSE;

	/**
	 * 是否前台显示，用来逻辑删除
	 */
	private Boolean visiable;

	/***
	 * 省市区翻译
	 */
	@Transient
	private List<DictProviceCity> proviceCityList;

	public Address() {
	}

	public Address(Long id) {
		this.id = id;
	}

	@JsonIgnore
	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getRecipient() {
		return recipient;
	}

	public void setRecipient(String recipient) {
		this.recipient = recipient;
	}

	public String getPostcode() {
		return postcode;
	}

	public void setPostcode(String postcode) {
		this.postcode = postcode;
	}

	public String getRecipientPhone() {
		return recipientPhone;
	}

	public void setRecipientPhone(String recipientPhone) {
		this.recipientPhone = recipientPhone;
	}

	@JsonIgnore
	public DictProviceCity getProvCity() {
		return provCity;
	}

	public void setProvCity(DictProviceCity provCity) {
		this.provCity = provCity;
	}

	public boolean isDefaultAddr() {
		return defaultAddr;
	}

	public void setDefaultAddr(boolean defaultAddr) {
		this.defaultAddr = defaultAddr;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public Boolean getVisiable() {
		return visiable;
	}

	public void setVisiable(Boolean visiable) {
		this.visiable = visiable;
	}

	public List<DictProviceCity> getProviceCityList() {
		return proviceCityList;
	}

	public void setProviceCityList(List<DictProviceCity> proviceCityList) {
		this.proviceCityList = proviceCityList;
	}

}