package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.entity.dict.DictAdvType;


/**
 * Banner广告
 * @author zhangmin
 */
@SuppressWarnings("all")
@JsonIgnoreProperties(ignoreUnknown=true)
public class BannerAdv extends IdEntity{

	/**
	 */
	private static final long serialVersionUID = 4920184245836973256L;

	/** 广告位置 */
	private DictAdvType type;
	
	/**广告标题*/
	private String title;
	
	/** 广告宣传语 */
	private String advWord;
	
	/**
	 *图片来源 
	 */
	private CallWay imgSource;
	
	/**
	 * 图片地址 
	 * 说明：如果是图片来源是远程调用，则保存的值是：http://www.xxx.com/imgfile.jpg
	 *     如果图片来源是本地上传，则保存的是图片上传后保存的相对路径，例如：xxxx/imgfile.jpg
	 */
	private String imgUrl;
	
	
	/**点击广告 链接地址*/
	private String linkUrl;
	
	
	/**
	 * 显示顺序  数字越小，显示越靠前
	 */
	private int displayOrder;
	
	/**
	 * 是否在前台页面显示
	 */
	private boolean visible = true;
	
	/**
	 * 背景颜色值
	 */
	private String bgColor;
	
	
	
	public static enum CallWay{
		
		URL_INVOKE("地址调用"), UPLOAD("本地上传");
		
		
		private String label;
		
		CallWay(String label){
			this.label = label;
		}

		public String getLabel() {
			return label;
		}

		public void setLabel(String label){
			this.label = label;
		}
	}


	public String getTitle() {
		return title;
	}



	public void setTitle(String title) {
		this.title = title;
	}



	public CallWay getImgSource() {
		return imgSource;
	}



	public void setImgSource(CallWay imgSource) {
		this.imgSource = imgSource;
	}



	public String getImgUrl() {
		return imgUrl;
	}

	public void setImgUrl(String imgUrl){
		this.imgUrl = imgUrl;
	}

	
	/**
	 * 返回<Img>Tag 可以加载的图片url
	 */
	public String getLoadableImgUrl(){
		if(CallWay.URL_INVOKE.equals(this.imgSource)){
			return imgUrl;
		}
        return null;
	}
	


	public String getLinkUrl() {
		return linkUrl;
	}



	public void setLinkUrl(String linkUrl) {
		this.linkUrl = linkUrl;
	}



	public int getDisplayOrder() {
		return displayOrder;
	}



	public void setDisplayOrder(int displayOrder) {
		this.displayOrder = displayOrder;
	}



	public boolean isVisible() {
		return visible;
	}



	public void setVisible(boolean visible) {
		this.visible = visible;
	}



	public String getAdvWord(){
		return advWord;
	}


	public void setAdvWord(String advWord) {
		this.advWord = advWord;
	}


    public DictAdvType getType() {
        return type;
    }

    public void setType(DictAdvType type) {
        this.type = type;
    }

    public String getBgColor() {
		return bgColor;
	}



	public void setBgColor(String bgColor) {
		this.bgColor = bgColor;
	}

	/**
	 * 获取图片的全路径
	 * @return
	 */
	public String getFullImageUrl() {
		return PropertyHolder.getFullImageUrl(this.getImgUrl());
	}
}