package com.rocoinfo.rocomall.entity;

import com.rocoinfo.rocomall.entity.dict.DictRankType;
import com.rocoinfo.rocomall.enumconst.Status;

/**
 * 特殊位置显示的产品
 *
 * @author zhangmin
 */
public class ProductSpecial extends IdEntity {
    private static final long serialVersionUID = 4932059502564187415L;

    public static final String COLUMN_TYPE = "type";
    public static final String COLUMN_DISPLAY_ORDER = "display_order";
    public static final String COLUMN_CATALOG_ID = "catalog_id";

    private DictRankType type;

    private Long catalogId;

    private Catalog catalog;

    private Sku sku;

    private Integer displayOrder;

    private Status status;

    public Long getCatalogId() {
        return catalogId;
    }

    public void setCatalogId(Long catalogId) {
        this.catalogId = catalogId;
    }

    public Integer getDisplayOrder() {
        return displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public Sku getSku() {
        return sku;
    }

    public void setSku(Sku sku) {
        this.sku = sku;
    }

    public Catalog getCatalog() {
        return catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public DictRankType getType() {
        return type;
    }

    public void setType(DictRankType type) {
        this.type = type;
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static enum SpecialType {
        RECOMMEND("推荐商品"),
        NEW("最新商品"),
        HIGH_END("高端专区"), // 高端专区 只能设置高端商品
        TOP_EXCHANGE("兑换排行榜"),
        HOT_EXCHANGE("热门兑换", true),
        GUESS_LIKE("猜您喜欢", true),
        WAP_RECOMMEND("WAP推荐商品");

        SpecialType(String label) {
            this.label = label;
        }

        SpecialType(String label, boolean bindCatalog) {
            this.label = label;
            this.bindCatalog = bindCatalog;
        }

        private boolean bindCatalog;
        private String label;

        public String getLabel() {
            return label;
        }

        public boolean isBindCatalog() {
            return bindCatalog;
        }
    }
}