package com.rocoinfo.rocomall.entity;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 虚拟商品卡密
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class VirtualProduct extends IdEntity {

	private static final long serialVersionUID = -5616517550902170595L;

	private String skuId;
	
	/**
	 * sku编码
	 */
	private String skuCode;

	/**
	 * 卡密的 序列号
	 */
	private String serialNo;

	/**
	 * 卡号
	 */
	private String cardno;

	/**
	 * 卡密的密码 或 兑换码
	 */
	private String passwd;

	/**
	 * 虚拟卡有效期
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date expired;

	/**
	 * 状态
	 */
	private Status status;

	/**
	 * 虚拟商品类型(兑换码 卡密)
	 */
	private Type type;

	/**
	 * 备注
	 */
	private String remark;

	public static enum Type {
		EXCHANGE_CODE("兑换码"), CARD_PWD("卡密");
		private String label;

		Type(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}

		public static Type valueOfName(String name) {
			for (Type type : Type.values()) {
				if (type.getLabel().equals(name)) {
					return type;
				}
			}
			return null;
		}
	}

	public static enum Status {
		UNUSED("未使用"), USED("已使用"), EXPRIED("已过期"), CANCEL("作废");

		private String label;

		Status(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}

		public static Status getItemByName(String name) {

			for (Status t : Status.values()) {
				if (t.name().equals(name)) {
					return t;
				}
			}
			return null;
		}
	}

	public VirtualProduct() {
	}

	public VirtualProduct(Long id) {
		this.id = id;
	}

	public String getPasswd() {
		return passwd;
	}

	public void setPasswd(String passwd) {
		this.passwd = passwd;
	}

	public Date getExpired() {
		return expired;
	}

	public void setExpired(Date expired) {
		this.expired = expired;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public Type getType() {
		return type;
	}

	public void setType(Type type) {
		this.type = type;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public String getCardno() {
		return cardno;
	}

	public void setCardno(String cardno) {
		this.cardno = cardno;
	}

	public String getSerialNo() {
		return serialNo;
	}

	public void setSerialNo(String serialNo) {
		this.serialNo = serialNo;
	}

	public String getSkuId() {
		return skuId;
	}

	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}
	
}
