package com.rocoinfo.rocomall.entity.activity;

import javax.validation.constraints.Pattern;

import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

import com.rocoinfo.rocomall.entity.IdEntity;

/**
 * Created by wangx on 14-10-21.
 */

public class AuctionHitUser extends IdEntity {

	private static final long serialVersionUID = -5870736552878658567L;
	private AuctionActivityRecord auctionActivityRecord;

	// 用户名，跟用户表的名不一样提示
	private String name;

	// 配偶名称
	private String spouseName;

	private String idcard;

	// 安利号
	private String adaNumber;

	private String mobile;

	private String phone;

	private String postAddr;

	private String email;

	public AuctionActivityRecord getAuctionActivityRecord() {
		return auctionActivityRecord;
	}

	public void setAuctionActivityRecord(AuctionActivityRecord auctionActivityRecord) {
		this.auctionActivityRecord = auctionActivityRecord;
	}

	@NotBlank(message = "姓名不能为空")
	@SafeHtml()
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@SafeHtml
	public String getSpouseName() {
		return spouseName;
	}

	public void setSpouseName(String spouseName) {
		this.spouseName = spouseName;
	}

	@NotBlank(message = "身份证号码不能为空")
	public String getIdcard() {
		return idcard;
	}

	public void setIdcard(String idcard) {
		this.idcard = idcard;
	}

	@Pattern(regexp = "\\d+", message = "安利卡号格式有误")
	public String getAdaNumber() {
		return adaNumber;
	}

	public void setAdaNumber(String adaNumber) {
		this.adaNumber = adaNumber;
	}

	@Pattern(regexp = "1\\d{10}", message = "手机号码格式有误")
	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	@Pattern(regexp = "\\d{0}|\\d{3,4}-\\d{7,8}", message = "家庭电话格式有误")
	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	@SafeHtml
	public String getPostAddr() {
		return postAddr;
	}

	public void setPostAddr(String postAddr) {
		this.postAddr = postAddr;
	}

	@Email(message = "电子邮箱格式有误")
	@SafeHtml
	@NotBlank(message = "电子邮箱不能为空")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}
}