package com.rocoinfo.rocomall.entity.cent;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.AdminUser;

public abstract class Approve<T extends Apply> extends IdEntity {

    private static final long serialVersionUID = 1L;

    private T apply;

    private AdminUser approver;

    private ApproveResult result;

    private String notation;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss" , timezone = "GMT+8")
    private Date auditDate;

    public enum ApproveResult {

        AGREE("通过"), DISAGREE("不通过"), RETURN("退回");

        private final String label;

        ApproveResult(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }

    public AdminUser getApprover() {
        return approver;
    }

    public T getApply() {
        return apply;
    }

    public void setApply(T apply) {
        this.apply = apply;
    }

    public void setApprover(AdminUser approver) {
        this.approver = approver;
    }

    public ApproveResult getResult() {
        return result;
    }

    public void setResult(ApproveResult result) {
        this.result = result;
    }

    public Date getAuditDate() {
        return auditDate;
    }

    public void setAuditDate(Date auditDate) {
        this.auditDate = auditDate;
    }

    public String getNotation() {
        return notation;
    }

    public void setNotation(String notation) {
        this.notation = notation;
    }
}