package com.rocoinfo.rocomall.entity.coupons;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.User;

/**
 * 优惠卷发放实体类
 * 
 * @author YUZHE 2015年12月11日 上午11:52:36
 */
public class CouponsProvideInfo extends IdEntity {

	private static final long serialVersionUID = 1L;

	private CouponsInfo coupons;
	// 总订单号
	private String orderCode;
	// 是否使用
	private Boolean used;
	// 关联用户
	private User user;
	// 状态
	private Status status;
	// 发放时间
	@JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT+8")
	private Date createTime;

	public static enum Status {
		EFFECTIVE("有效"), UNEFFECTIVE("失效");

		private String label;

		Status(String label) {
			this.label = label;
		}

		public String getLabel() {
			return this.label;
		}
	}

	public CouponsInfo getCoupons() {
		return coupons;
	}

	public void setCoupons(CouponsInfo coupons) {
		this.coupons = coupons;
	}

	public Boolean getUsed() {
		return used;
	}

	public void setUsed(Boolean used) {
		this.used = used;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

}
