package com.rocoinfo.rocomall.entity.dict;

import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;

/**
 * @author zhangmin 省/市/县 基础字典 Entity
 */
public class DictProviceCity extends IdEntity {

	private static final long serialVersionUID = -7189001539704157798L;

	private String name;

	/**
	 * 父id
	 */
	private Long pid = 0L;

	/**
	 * 显示顺序
	 */
	private Integer displayOrder = 0;

	/**
	 * 运费
	 */
	private Double deliverFee;

	/**
	 * 免运费限额, 即订单金额 >= 此金额，则免运费, 如果设置为0，则收运费
	 */
	private Double freeLimitAmt;

	//以下为非持久化属性

	/**
	 * 与当前节点同层级的所有节点列表 --在编辑用户地址详细时使用
	 */
	@Transient
	private List<DictProviceCity> curNodeList;

	@Transient
	private List<DictProviceCity> childNodes;

	@Transient
	private boolean selected;

	@Transient
	private DictExpress express;

	@JsonIgnore
	public List<DictProviceCity> getCurNodeList() {
		return curNodeList;
	}

	public void setCurNodeList(List<DictProviceCity> curNodeList) {
		this.curNodeList = curNodeList;
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public DictProviceCity() {
	}

	public DictProviceCity(Long addrId) {
		this.id = addrId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getPid() {
		return pid;
	}

	public void setPid(Long pid) {
		this.pid = pid;
	}

	@JsonIgnore
	public Integer getDisplayOrder() {
		return displayOrder;
	}

	public void setDisplayOrder(Integer displayOrder) {
		this.displayOrder = displayOrder;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public Double getDeliverFee() {
		return deliverFee;
	}

	public void setDeliverFee(Double deliverFee) {
		this.deliverFee = deliverFee;
	}

	public Double getFreeLimitAmt() {
		return freeLimitAmt;
	}

	public void setFreeLimitAmt(Double freeLimitAmt) {
		this.freeLimitAmt = freeLimitAmt;
	}

	public List<DictProviceCity> getChildNodes() {
		return childNodes;
	}

	public void addChild(DictProviceCity child) {
		if (child != null) {
			if (this.childNodes == null) {
				this.childNodes = Lists.newArrayList();
			}
			this.childNodes.add(child);
		}
	}

	public void setChildNodes(List<DictProviceCity> childNodes) {
		this.childNodes = childNodes;
	}

	@JsonIgnore
	public DictExpress getExpress() {
		return express;
	}

	public void setExpress(DictExpress express) {
		this.express = express;
	}
}