package com.rocoinfo.rocomall.entity.insurance;


import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.Company;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.enumconst.Gender;


/**
 * <dl>
 * <dd>描述:受保人实体</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015/12/29 15:22</dd>
 * <dd>@author：huyt</dd>
 * </dl>
 */
public class InsuredInfo extends IdEntity {

    /**
     * 默认构造函数
     */
    public InsuredInfo() {
    }

    /**
     * 根据手机号构造javabean
     *
     * @param mobile 手机号
     */
    public InsuredInfo(String mobile) {
        this.mobile = mobile;
    }

    /**
     * 姓名
     */
    private String name;

    /**
     * 证件类型
     */
    private CardType cardType;

    /**
     * 证件号码
     */
    private String cardNo;

    /**
     * 性别
     */
    private Gender gender;

    /**
     * 出生日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GTM+8")
    private Date birthdate;

    /**
     * 身高
     */
    private String height;

    /**
     * 体重
     */
    private String weight;

    /**
     * 联系地址
     */
    private String address;

    /**
     * 公司code
     */
    private Company company;

    /**
     * 电子邮件
     */
    private String email;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 微信头像
     */
    private String headImg;

    /**
     * 微信昵称 不存数据库
     */
    private String nickName;

    /**
     * 年龄 不存数据库
     */
    private int age;

    /**
     * 证件类型枚举
     */
    public enum CardType {
        IDENTITY_CARD("身份证"), MILITARY_CARD("军人证"), PASSPORT("护照"), BIRTH_CERTIFICATE("出生证"),
        ABNORMAL_ID("异常身份证"), HK_MACAO_PASS("港澳居民来往内地通行"), OTHERS("其他");

        private String label;

        CardType(String lable) {
            this.label = lable;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CardType getCardType() {
        return cardType;
    }

    public void setCardType(CardType cardType) {
        this.cardType = cardType;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public Gender getGender() {
        return gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Date getBirthdate() {
        return birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }
}
