package com.rocoinfo.rocomall.entity.order;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.ArrayUtils;
import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.dto.LogisticInfoDto;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.activity.Activity;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;

/**
 * <dl>
 * <dd>描述: 子订单项实体bean</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015/9/17 20:38</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 * 
 * @author huyt
 * @author zhangmin
 */
public class OrderItem extends IdEntity {

	private static final long serialVersionUID = -381856613643818591L;

	/**
	 * 订单编号
	 */
	private String orderCode;

	/**
	 * 订单类型
	 */
	private OrderType orderType;

	/** 订单分组属性 **/
	private Group group;

	/**
	 * 活动
	 */
	private Activity activity;

	/**
	 * 库存
	 */
	private Sku sku;

	/**
	 * 下单时 sku所在的仓库
	 */
	private DictWarehouse wareHouse;

	/**
	 * 销售的真实数量
	 */
	private Integer quantity;

	/**
	 * 支付商品单价(现金)
	 */
	private Double price;

	/**
	 * 商品原价
	 */
	private Integer originalCent;

	/**
	 * 支付积分单价（积分）
	 */
	private Integer cent;

	/**
	 * 对应主订单
	 */
	private Order order;

	/**
	 * 子订单状态
	 */
	private Status status;

	/**
	 * 管理状态
	 */
	private AdmStatus admStatus;

	/**
	 * 用户
	 */
	private User user;

	/**
	 * 商品名称(下单时)
	 */
	private String productName;

	/**
	 * 创建时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT+8")
	private Date createTime;

	/**
	 * 快递公司
	 */
	private DictExpress express;

	/**
	 * 运单号
	 */
	private String transportNo;

	/**
	 * 供应商
	 */
	private Supplier supplier;

	/**
	 * 物流信息
	 */
	@Transient
	private LogisticInfoDto logisticInfo;

	public OrderItem() {
	}

	public OrderItem(Long id) {
		this.id = id;
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public Sku getSku() {
		return sku;
	}

	public void setSku(Sku sku) {
		this.sku = sku;
	}

	public Activity getActivity() {
		return activity;
	}

	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public Double getPrice() {
		return price;
	}

	public void setPrice(Double price) {
		this.price = price;
	}

	public Integer getCent() {
		return cent;
	}

	public void setCent(Integer cent) {
		this.cent = cent;
	}

	public Integer getOriginalCent() {
		return originalCent;
	}

	public void setOriginalCent(Integer originalCent) {
		this.originalCent = originalCent;
	}

	public Order getOrder() {
		return order;
	}

	public void setOrder(Order order) {
		this.order = order;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

	public AdmStatus getAdmStatus() {
		return admStatus;
	}

	public void setAdmStatus(AdmStatus admStatus) {
		this.admStatus = admStatus;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public OrderType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderType orderType) {
		this.orderType = orderType;
	}

	public DictExpress getExpress() {
		return express;
	}

	public void setExpress(DictExpress express) {
		this.express = express;
	}

	public String getTransportNo() {
		return transportNo;
	}

	public void setTransportNo(String transportNo) {
		this.transportNo = transportNo;
	}

	public LogisticInfoDto getLogisticInfo() {
		return logisticInfo;
	}

	public void setLogisticInfo(LogisticInfoDto logisticInfo) {
		this.logisticInfo = logisticInfo;
	}

	public Group getGroup() {
		return group;
	}

	public void setGroup(Group group) {
		this.group = group;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Supplier getSupplier() {
		return supplier;
	}

	public void setSupplier(Supplier supplier) {
		this.supplier = supplier;
	}

	/**
	 * 订单类型枚举
	 */
	public enum OrderType {
		common("普通订单", "10"), groupon("团购订单", "11"), auction("竞拍订单", "12"), seckill("秒杀订单", "13"), presale("预售订单", "14"), limited_time("限时抢购订单", "15"), commonweal("公益订单", "16"), scrape_card("刮刮卡订单", "17"), turn_table("转盘抽奖订单", "18"), visual("虚拟订单",
			"19"), exchange("兑换订单", "20");

		OrderType(String label, String code) {
			this.label = label;
			this.code = code;
		}

		private String code;
		private String label;

		public String getCode() {
			return code;
		}

		public String getLabel() {
			return label;
		}
	}

	/**
	 * 订单处理枚举
	 */
	public enum OrderAction {
		BATCH_DEAL("批量处理"), MANUAL_DEAL("手工处理"), CANCEL("取消"), //
		BATCH_SEND("批量发货"), MANUAL_SEND("手工发货"), //
		RECEIVE("确认收货"), MODIFY_LOGISTIC("修改物流信息"), //
		REFUND("退货"), EXCHANGE("换货"), //
		COMPLETE_REFUND("完成退货"), COMPLETE_EXCHANGE("完成换货");

		private final String name;

		OrderAction(String name) {
			this.name = name;
		}

		public String getName() {
			return name;
		}

	}

	/**
	 * 后台管理状态
	 */
	public enum AdmStatus {
		NOT_PAID("待支付"), PART_PAID("部分支付"), PAID("支付成功"), EXCEPTION("异常"), LOCKED("异常锁定"), DISTRIBUTED("已生成配送单"), DISTRIBUTION_MERGED("配送单已合并"), DISTRIBUTION_WAIT_OUT("配送单待出库"), DISTRIBUTION_OUTED("配送单已出库"), DELIVERED("配送单配送中"), FINISH("已完成"), CANCELED(
			"已取消"), REFUND_TOACCEPT("退货待受理"), REFUND_ACCEPT("退货已受理"), REFUND_INSTORE("退货已生成入库单"), REFUND_LOGISTED("退货已输入物流单号"), REFUND_RECEIVED("退货已确认收货"), REFUNDED("已退货");
		AdmStatus(String label) {
			this.label = label;
		}

		private String label;

		public String getLabel() {
			return this.label;
		}
	}

	/**
	 * 前台订单状态枚举
	 */
	public enum Status {
		NOT_PAID("待支付"), PAID("支付成功", OrderAction.BATCH_DEAL, OrderAction.MANUAL_DEAL, OrderAction.CANCEL), // 已支付或已下单
		RECEIVING("待收货"), FINISH("已完成"), CANCELED("已取消"), REFUND_TOACCEPT("退货待受理"), REFUND_ACCEPT("退货已受理"), REFUNDING("退货中"), REFUNDED("已退货"),

		/**
		 * 下面的状态被删除了
		 */
		DEALED("已处理", OrderAction.BATCH_SEND, OrderAction.MANUAL_SEND), //订单导出后变成已处理
		SENDING("配送中", OrderAction.RECEIVE, OrderAction.MODIFY_LOGISTIC), // 已发货
		SUCCESS("已完成", OrderAction.REFUND, OrderAction.EXCHANGE), // 已到货(用户已经确认收货)
		EXCHANGING("换货中", OrderAction.COMPLETE_EXCHANGE), //会员收到货以后，可以填写换货申请，管理员审批通过后，状态变成=> “换货中”
		EXCHANGED("换货成功");//换货会员签收后，状态变成=> 换货成功

		private final String label;
		private List<OrderAction> supportedActions;

		Status(String label, OrderAction... supportedActs) {
			this.label = label;
			if (ArrayUtils.isNotEmpty(supportedActs)) {
				this.supportedActions = Arrays.asList(supportedActs);
			}
		}

		public String getLabel() {
			return label;
		}

		public List<OrderAction> getSupportedActions() {
			return supportedActions;
		}
	}

	public DictWarehouse getWareHouse() {
		return wareHouse;
	}

	public void setWareHouse(DictWarehouse wareHouse) {
		this.wareHouse = wareHouse;
	}

	public static enum Group {
		MATERIAL("实物类"), CRADPWD("卡密类"), EXCHANGE("兑换类");
		private String label;

		Group(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}
}