package com.rocoinfo.rocomall.entity.order;

import java.util.Date;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;

/**
 * <dl>
 * <dd>描述:出库单</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月16日 上午10:41:44</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
public class OrderOutStore extends IdEntity {

	private static final long serialVersionUID = 5218967691241235209L;
	/**
	 * 出库单号
	 */
	private String code;
	/**
	 * 操作人(数据库字段：operatorId)(更改订单状态的人)
	 */
	private AdminUser operator;
	/**
	 * 操作时间(更改订单状态的时间)
	 */
	private Date operateDatetime;
	/**
	 * 是否已出库，
	 */
	private Boolean state;

	/**
	 * 出库商品（数据库字段：skuId，skuCode，skuName）
	 */
	private Sku sku;
	/**
	 * 商品所在仓库（数据库字段：dictWarehouseId，dictWarehouseName）
	 */
	private DictWarehouse warehouse;
	/**
	 * 快递公司(数据库字段：expressId，expressName)
	 */
	private DictExpress express;
	/**
	 * 出库数量
	 */
	private int quantity;
	/**
	 * 出库时间
	 */
	private Date createTime;

	/**
	 * 出库单号
	 */
	public String getCode() {
		return code;
	}

	/**
	 * 出库单号
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * 操作人(数据库字段：operatorId)(更改订单状态的人)
	 */
	public AdminUser getOperator() {
		return operator;
	}

	/**
	 * 操作人(数据库字段：operatorId)(更改订单状态的人)
	 */
	public void setOperator(AdminUser operator) {
		this.operator = operator;
	}

	/**
	 * 操作时间(更改订单状态的时间)
	 */
	public Date getOperateDatetime() {
		return operateDatetime;
	}

	/**
	 * 操作时间(更改订单状态的时间)
	 */
	public void setOperateDatetime(Date operateDatetime) {
		this.operateDatetime = operateDatetime;
	}

	/**
	 * 是否已出库，0未出库，1已出库
	 */
	public Boolean getState() {
		return state;
	}

	public void setState(Boolean state) {
		this.state = state;
	}

	/**
	 * 出库商品（数据库字段：skuId，skuCode，skuName）
	 */
	public Sku getSku() {
		return sku;
	}

	/**
	 * 出库商品（数据库字段：skuId，skuCode，skuName）
	 */
	public void setSku(Sku sku) {
		this.sku = sku;
	}

	/**
	 * 商品所在仓库（数据库字段：dictWarehouseId，dictWarehouseName）
	 */
	public DictWarehouse getWarehouse() {
		return warehouse;
	}

	/**
	 * 商品所在仓库（数据库字段：dictWarehouseId，dictWarehouseName）
	 */
	public void setWarehouse(DictWarehouse warehouse) {
		this.warehouse = warehouse;
	}

	/**
	 * 快递公司(数据库字段：expressId，expressName)
	 */
	public DictExpress getExpress() {
		return express;
	}

	/**
	 * 快递公司(数据库字段：expressId，expressName)
	 */
	public void setExpress(DictExpress express) {
		this.express = express;
	}

	/**
	 * 出库数量
	 */
	public int getQuantity() {
		return quantity;
	}

	/**
	 * 出库数量
	 */
	public void setQuantity(int quantity) {
		this.quantity = quantity;
	}

	/**
	 * 出库时间
	 */
	public Date getCreateTime() {
		return createTime;
	}

	/**
	 * 出库时间
	 */
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
}
