package com.rocoinfo.rocomall.entity.workorder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.entity.order.OrderItem;

/**
 * <dl>
 * <dd>描述:客服工单退货记录</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月18日 上午10:34:59</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
public class WorkOrderRefundDetail extends IdEntity {

	private static final long serialVersionUID = 5532560673949179287L;

	/**
	 * 工单号
	 */
	@JsonIgnore
	private WorkOrder workOrder;

	/**
	 * 子订单
	 */
	private OrderItem orderItem;

	/**
	 * 退货商品
	 */
	private Sku sku;
	/**
	 * 退货商品所在仓库
	 */
	private DictWarehouse warehouse;

	/**
	 * 退货数量
	 */
	private int quantity;

	/**
	 * 退积分数量（已乘以退货数量）
	 */
	private int cent;

	/**
	 * 退现金数 （已乘以退货数量）
	 */
	private double amount;

	/**
	 * 是否已经成功 退货
	 */
	private Boolean refunded;

	/**
	 * 工单
	 */
	public WorkOrder getWorkOrder() {
		return workOrder;
	}

	/**
	 * 工单号
	 */
	public void setWorkOrder(WorkOrder workOrder) {
		this.workOrder = workOrder;
	}

	public OrderItem getOrderItem() {
		return orderItem;
	}

	public void setOrderItem(OrderItem orderItem) {
		this.orderItem = orderItem;
	}

	public Sku getSku() {
		return sku;
	}

	public void setSku(Sku sku) {
		this.sku = sku;
	}

	public DictWarehouse getWarehouse() {
		return warehouse;
	}

	public void setWarehouse(DictWarehouse warehouse) {
		this.warehouse = warehouse;
	}

	public int getQuantity() {
		return quantity;
	}

	public void setQuantity(int quantity) {
		this.quantity = quantity;
	}

	/**
	 * 退积分数量
	 */
	public int getCent() {
		return cent;
	}

	/**
	 * 退积分数量
	 */
	public void setCent(int cent) {
		this.cent = cent;
	}

	/**
	 * 退现金数量
	 */
	public double getAmount() {
		return amount;
	}

	public void setAmount(double amount) {
		this.amount = amount;
	}

	public Boolean getRefunded() {
		return refunded;
	}

	public void setRefunded(Boolean refunded) {
		this.refunded = refunded;
	}
}
