package com.rocoinfo.rocomall.entity.wx;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangmin 单条消息，单个接收者
 */
public abstract class SingleMsgSingleReceiver implements WxMessage {

	private static final long serialVersionUID = -1663904269348247832L;
	private String messageId;

	public SingleMsgSingleReceiver() {
	}

	public SingleMsgSingleReceiver(String messageId) {
		this.messageId = messageId;
	}

	/**
	 * 获得要保存的消息，多图文消息则可以多条
	 * 
	 * @return
	 */
	public final List<MsgEntity> getMsgContents() {
		List<MsgEntity> msgList = new ArrayList<MsgEntity>(1);
		msgList.add(getMsgEntity());
		return msgList;
	}

	/***
	 * 获得消息接收者 如果消息的接收者可以是多个人，例如群发
	 * 
	 * @return
	 */
	public final List<MsgReceiverEntity> getMsgReceivers() {
		final List<MsgReceiverEntity> receiverList = new ArrayList<MsgReceiverEntity>(1);
		if (getMsgReceiver() != null) {
			receiverList.add(getMsgReceiver());
		}
		return receiverList;
	}

	public abstract MsgEntity getMsgEntity();

	public abstract MsgReceiverEntity getMsgReceiver();

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}
}