package com.rocoinfo.rocomall.entity.wx;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 微信发送被动响应消息：回复音乐消息
 */
//@XStreamAlias("item")
public class WXMusic {

	/**
	 * 音乐标题
	 */
	@XStreamAlias("Title")
	private String title;

	/***
	 * 音乐描述
	 */
	@XStreamAlias("Description")
	private String description;

	/***
	 * 音乐链接
	 */
	@XStreamAlias("MusicUrl")
	private String musicUrl;

	/**
	 * 高质量音乐链接，WIFI环境优先使用该链接播放音乐
	 */
	@XStreamAlias("HQMusicUrl")
	private String hQMusicUrl;

	/***
	 * 缩略图的媒体id，通过上传多媒体文件，得到的id
	 */
	@XStreamAlias("ThumbMediaId")
	private String thumbMediaId;

	public String getThumbMediaId() {
		return thumbMediaId;
	}

	public void setThumbMediaId(String thumbMediaId) {
		this.thumbMediaId = thumbMediaId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getMusicUrl() {
		return musicUrl;
	}

	public void setMusicUrl(String musicUrl) {
		this.musicUrl = musicUrl;
	}

	public String gethQMusicUrl() {
		return hQMusicUrl;
	}

	public void sethQMusicUrl(String hQMusicUrl) {
		this.hQMusicUrl = hQMusicUrl;
	}
}
