package com.rocoinfo.rocomall.pay.chinapay;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.Constants;

/**
 * 银联支付
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-10-28 下午1:33:31</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
public class ChinaPayInterfaceHelper {

	private static Logger logger = LoggerFactory.getLogger(ChinaPayInterfaceHelper.class);

	public static String MERID;// //MerId为ChinaPay统一分配给商户的商户号，15位长度，必填
	public static String PUBLIC_MERID;
	public static String PUBLIC_KEY;
	public static String PRIVATE_KEY;
	public static final String CURYID = "156";
	public static final String TRANSTYPE = "0001";
	public static final String VERSION = "20070129";
	public static final String URL = "https://payment.chinapay.com/pay/TransGet";

	public static Map<String, String> buildQueryParam(String orderId, double transAmt, String notify_url, String return_url) {
		Map<String, String> params = Maps.newHashMap();
		params.put("MerId", MERID);
		params.put("OrdId", orderId);
		String transAmtstr = formatMoney(transAmt);
		params.put("TransAmt", transAmtstr);
		params.put("CuryId", CURYID);
		String dataStr = DateUtils.formatDate(new Date(), Constants.YYYYMMDD_NJOIN);
		params.put("TransDate", dataStr);
		params.put("TransType", TRANSTYPE);
		params.put("Version", VERSION);
		params.put("BgRetUrl", notify_url);
		params.put("PageRetUrl", return_url);
		chinapay.PrivateKey key = new chinapay.PrivateKey();
		// 是否导入成功
		boolean keyLoaded = key.buildKey(MERID, 0, PRIVATE_KEY);
		logger.info("签名导入key:{}", keyLoaded);
		if (keyLoaded == false) {
			return null;
		}
		chinapay.SecureLink link = new chinapay.SecureLink(key);
		String chkValue = link.signOrder(MERID, orderId, transAmtstr, CURYID, dataStr, TRANSTYPE);
		params.put("ChkValue", chkValue);
		return params;
	}

	public static boolean isPaySuccess(HttpServletRequest request) {
		String tradeDate = request.getParameter("transdate");
		String merId = request.getParameter("merid");
		// 返回的商户业务订单号
		String ordId = request.getParameter("orderno");
		String transType = request.getParameter("transtype");
		String transAmt = request.getParameter("amount");
		String curyId = request.getParameter("currencycode");
		// 返回的交易状态 1001=>成功 其它为失败
		String orderStatus = request.getParameter("status");
		String chkValue = request.getParameter("checkvalue");
		chinapay.PrivateKey key = new chinapay.PrivateKey();
		boolean keyLoaded = false; // 是否成功导入密钥
		boolean verifyReturnResult = false; // 返回的数据是否合法
		keyLoaded = key.buildKey(PUBLIC_MERID, 0, PUBLIC_KEY);
		logger.info("验证导入key:{}", keyLoaded);
		if (keyLoaded) {
			chinapay.SecureLink link = new chinapay.SecureLink(key);
			verifyReturnResult = link.verifyTransResponse(merId, ordId, transAmt, curyId, tradeDate, transType, orderStatus, chkValue);
			logger.info("支付验证结果{}.orderStatus:{}", verifyReturnResult, orderStatus);
			// 数据合法并且支付成功
			if (verifyReturnResult && "1001".equals(orderStatus)) {
				return true;
			}
		}
		return false;
	}

	private static String formatMoney(double amount) {
		amount = amount * 100;
		DecimalFormat df = new DecimalFormat("000000000000");
		String money = df.format(amount);
		return money;
	}
}
