package com.rocoinfo.rocomall.pay.kuaiqian;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pkipair {
	private static Logger logger = LoggerFactory.getLogger(Pkipair.class);

	public String signMsg(String signMsg) {

		String base64 = "";
		FileInputStream ksfis = null;
		BufferedInputStream ksbufin = null;
		try {
			// 密钥仓库
			KeyStore ks = KeyStore.getInstance("PKCS12");
			// 读取密钥仓库
			// FileInputStream ksfis = new FileInputStream("e:/tester-rsa.pfx");
			// 读取密钥仓库（相对路径）
			ksfis = new FileInputStream(KuaiQianPayHelper.PRIVATE_RSA_PATH);
			ksbufin = new BufferedInputStream(ksfis);
			char[] keyPwd = KuaiQianPayHelper.KEY.toCharArray();// 密码
			ks.load(ksbufin, keyPwd);
			// 从密钥仓库得到私钥
			PrivateKey priK = (PrivateKey) ks.getKey(KuaiQianPayHelper.KEY_NAME, keyPwd);
			Signature signature = Signature.getInstance("SHA1withRSA");
			signature.initSign(priK);
			signature.update(signMsg.getBytes("utf-8"));
			sun.misc.BASE64Encoder encoder = new sun.misc.BASE64Encoder();
			base64 = encoder.encode(signature.sign());
		} catch (FileNotFoundException e) {
			logger.error("文件找不到");
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			IOUtils.closeQuietly(ksfis);
			IOUtils.closeQuietly(ksbufin);
		}
		return base64;
	}

	public boolean enCodeByCer(String val, String msg) {
		boolean flag = false;
		FileInputStream inStream = null;
		try {
			inStream = new FileInputStream(KuaiQianPayHelper.PUBLIC_RSA_PATH);
			CertificateFactory cf = CertificateFactory.getInstance("X.509");
			X509Certificate cert = (X509Certificate) cf.generateCertificate(inStream);
			// 获得公钥
			PublicKey pk = cert.getPublicKey();
			// 签名
			Signature signature = Signature.getInstance("SHA1withRSA");
			signature.initVerify(pk);
			signature.update(val.getBytes());
			// 解码
			sun.misc.BASE64Decoder decoder = new sun.misc.BASE64Decoder();
			flag = signature.verify(decoder.decodeBuffer(msg));
			logger.info("签名验证,{}", flag);
		} catch (Exception e) {
			e.printStackTrace();
			logger.info("签名验证失败");
		} finally {
			IOUtils.closeQuietly(inStream);
		}
		return flag;
	}
}
