package com.rocoinfo.rocomall.repository;

import java.util.List;
import java.util.Map;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.Address;

/**
 * 用户收货地址DAO Created by robin on 14-6-11. author yangxc
 */
@MyBatisRepository
public interface AddressDao extends CrudDao<Address>{

	/**
	 * 通过 用户id 和地址id 删除
	 * @return
	 */
	void removeUserAddress(Map<String,Object> paramMap);
	
	/**
	 * 获得用户的收货地址列表
	 * @param userId 用户id
	 * @return
	 */
	List<Address> findUserAddressList(Map<String,Object> paramMap);
	
	
	void setDefaultAddress(Map<String,Object> paramMap);
}
