package com.rocoinfo.rocomall.repository.coupons;

import java.util.List;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.coupons.CouponsInfo;
import com.rocoinfo.rocomall.entity.coupons.CouponsProvideInfo;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * 优惠卷信息
 * @author YUZHE
 * 2015年12月11日 下午1:45:55
 */
@MyBatisRepository
public interface CouponsInfoDao extends CrudDao<CouponsInfo> {

	/**
	 * 切换状态 可有 不可用
	 * @param id
	 * 2015年12月11日 下午4:54:43
	 */
	public void updateStatus(Long id);
	
	/**
	 * 根据code集合查询优惠卷信息
	 * @param codes
	 * 2015年12月14日 下午2:28:55
	 */
	public List<CouponsInfo> findCouponsByCode(List codes);
	
	/**
	 * 批量插入
	 * @param infoList
	 * 2015年12月14日 下午3:48:14
	 */
	public void batchInsert(List<CouponsProvideInfo> infoList);
}
