package com.rocoinfo.rocomall.service;

import java.util.List;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.Address;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/13 上午10:05</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
public interface IAddressService extends IBaseService<Address> {

    /**
     * 只做逻辑删除 通过 用户id 和地址id 删除, 防止用户恶意传参 地址id删除
     *
     * @param addrId 地址id
     * @param userId 地址所属用户Id
     */
    void removeUserAddress(final Long addrId, final Long userId);

    /**
     * 收货地址查询 省市县
     */
    void buildProvCityCounty(final List<Address> addressLists);

    /**
     * 设置用户默认收货地址
     *
     * @param defAddrId 默认收货地址Id
     * @param userId    用户Id
     */
    void setDefaultAddress(final Long defAddrId, final Long userId);

    List<Address> getAddressAndBuildProvCityCounty(final Long userId);

    /**
     * 通过用户Id获得他自己的收货地址列表
     *
     * @param userId
     * @param visiable
     * @return
     */
    List<Address> findUserAddressList(final Long userId, Boolean visiable);
}
