package com.rocoinfo.rocomall.service;

import java.util.UUID;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.repository.SmsSendInfoDao;
import com.rocoinfo.rocomall.utils.HttpUtils;

/**
 * 发生短信Service
 *
 * @author liuwei
 */
@Service
public class SmsService {
	
	private static Logger logger = LoggerFactory.getLogger(SmsService.class);
    /**
     * @return true 发送成功，false 发送失败
     */

    @Autowired
    private SmsSendInfoDao smsSendInfoDao;

    public boolean sendSms(String content,String... phoneNumbers){
    	content = PropertyHolder.getSmsContentPrefix()+content;
    	String logType = "send msg";
    	if(StringUtils.isEmpty(PropertyHolder.getSmsAppId())){
    		//旧的发短信接口   大诚若谷的发送短信appid为空
	        NameValuePair[] params = {
	                new BasicNameValuePair("type", "4"),
	                new BasicNameValuePair("SignType", "00"),
	                new BasicNameValuePair("mobile", phoneNumbers[0]),
	                new BasicNameValuePair("msg", content )
	        };
	        //"0"  =>表示发送成功
	        String status = HttpUtils.get(PropertyHolder.getSmsGateWay(), params);
	        logger.info("{} user rocoinfo interface ,content:{},phones:{},result:{}",logType,content,phoneNumbers[0],status);
	        return "\"0\"".equals(status);
       } 
    	if(phoneNumbers.length>100){
    		throw new ServiceException("手机号最多不能超过100个");
    	}
    	String version = "1.0";
    	//String sendTime = "";发送时间 ，可以为空。
    	String joinPhoneNumbersString =  StringUtils.join(phoneNumbers, ",");
    	String appId  = PropertyHolder.getSmsAppId();
    	String appSecret = PropertyHolder.getSmsAppSecret();
    	String timestamp  = String.valueOf(System.currentTimeMillis());
    	String batchNo  = UUID.randomUUID().toString();
    	StringBuffer sb = new StringBuffer();
    	sb.append(version);
    	sb.append(appId).append(timestamp).append(batchNo);
    	sb.append(joinPhoneNumbersString).append(content);
    //	sb.append(sendTime);
    	sb.append(appSecret);
    	
    	String md5Value = DigestUtils.md5Hex(sb.toString());//md5加密
    	NameValuePair[] params = {
    			new BasicNameValuePair("version", version),
                 new BasicNameValuePair("appId", appId),
                 new BasicNameValuePair("timestamp", timestamp),
                 new BasicNameValuePair("batchNo", batchNo),
                 new BasicNameValuePair("mobileNo", joinPhoneNumbersString), 
                 new BasicNameValuePair("content", content) , 
                // new BasicNameValuePair("sendTime", content) ,
                 new BasicNameValuePair("sign", md5Value)
         };
         //"0"  =>表示发送成功
         String status = HttpUtils.post(PropertyHolder.getSmsGateWay(), params);
         this.insert(joinPhoneNumbersString,content,"0".equals(status));
         logger.info("{} user newchina interface ,appId:{},appSecret:{},timestamp:{},batchNo:{},md5Value:{}",logType,appId,appSecret,timestamp,batchNo,md5Value);
         logger.info("{} user newchina interface ,content:{},phones:{},url:{},result:{}",logType,content,phoneNumbers[0],PropertyHolder.getSmsGateWay(),status);
         return true;
    }

    //短信验证码发送记录
    public void insert(String mobilePhone,String smsContent,boolean success) {
//        SmsSendInfo smsSendInfo = new SmsSendInfo();
//        smsSendInfo.setTelPhone(mobilePhone);
//        smsSendInfo.setUserId(WebUtils.getLoggedUserId());
//        smsSendInfo.setSmsContent(smsContent);
//        smsSendInfo.setSendStatus(success);
//        smsSendInfo.setCreateTime(new Date());
//        smsSendInfoDao.insert(smsSendInfo);
    }
}
