package com.rocoinfo.rocomall.service.coupons;

import java.util.List;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.dto.CouponsInfoDto;
import com.rocoinfo.rocomall.entity.coupons.CouponsInfo;
import com.rocoinfo.rocomall.entity.coupons.CouponsProvideInfo;

/**
 * 优惠卷
 * @author YUZHE
 * 2015年12月11日 下午1:51:37
 */
public interface ICouponsInfoService extends IBaseService<CouponsInfo> {

	/**
	 * 根据code查询 code是否存在  
	 * @param code
	 * @return	true:存在，false：不存在
	 * 2015年12月11日 下午3:50:46
	 */
	public boolean isHasCode(String code);
	
	/**
	 * 切换状态 可有 不可用
	 * @param id
	 * 2015年12月11日 下午4:54:43
	 */
	public void updateStatus(Long id);
	
	/**
	 * 批量发放
	 * @param cardList
	 * @return
	 * 2015年12月14日 下午2:16:09
	 */
	public Object batchProvide(List<CouponsInfoDto> cardList);
	
	/**
	 * 批量插入
	 * @param infoList
	 * 2015年12月14日 下午3:44:50
	 */
	public void batchInsert(List<CouponsProvideInfo> infoList);
}
