package com.rocoinfo.rocomall.service.dict.express;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeTemplate;

/**
 * <dl>
 * <dd>描述:快递计算费用模板Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/19 上午9:30</dd>
 * <dd>创建人： zhangmin</dd>
 * </dl>
 */
public interface IExpressFeeTemplateService extends IBaseService<ExpressFeeTemplate> {

	/**
	 * 根据模板id,查询此模板详细信息，包括该模板的子项，及模板子项绑定的城市
	 * 
	 * @param id 模板Id
	 */
	ExpressFeeTemplate getTemplateDetailById(Long id);

	/**
	 * 根据原始模板 id 复制新模板
	 * 
	 * @param id 模板Id
	 */
	ExpressFeeTemplate cloneTemplate(Long id);

	/**
	 * 通过快递公司Id,统计该快递公司的模板数量
	 * 
	 * @param expressTemplate
	 */
	public long countTemplateByExpress(ExpressFeeTemplate expressTemplate);

	/**
	 * 计算运费
	 * 
	 * @param orderWeight 购买的订单的 （件数|重量|体积）
	 */
	public double calculateDeliverFee(final Long cityId, final Long expressId, int orderWeight);
}
