package com.rocoinfo.rocomall.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Attention;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.repository.AttentionDao;
import com.rocoinfo.rocomall.service.IAttentionService;
import com.rocoinfo.rocomall.service.product.ISkuService;

/**
 * <dl>
 * <dd>描述: 用户关注 Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015/9/22 16:34</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 */
@Service
public class AttentionService extends CrudService<AttentionDao, Attention> implements IAttentionService {

    @Autowired
    private ISkuService skuService;

    @Override
    public Page<Sku> queryAttentionList(Map<String, Object> params, PageRequest pageable) {
        params.put(Constants.PAGE_OFFSET, pageable.getOffset());
        params.put(Constants.PAGE_SIZE, pageable.getPageSize());
        params.put(Constants.PAGE_SORT, pageable.getSort());
        List<Map> attentions = this.entityDao.queryAttentionList(params);
        Long count = this.entityDao.queryTotal(params);
        List<Sku> skus = new ArrayList<Sku>();
        for (Map attention : attentions) {
            Sku sku = skuService.getById(((Integer) attention.get("skuId")).longValue());
            skuService.buildCartSkuDetail(sku);
            skus.add(sku);
        }
        return new PageImpl<Sku>(skus, pageable, count);
    }
}
